/*
 * Decompiled with CFR 0.152.
 */
package cz.d1x.dxcrypto.common;

import cz.d1x.dxcrypto.common.Base64Representation;
import cz.d1x.dxcrypto.common.HexRepresentation;
import java.io.UnsupportedEncodingException;
import org.junit.Assert;
import org.junit.Test;

public class ByteRepresentationsTest {
    @Test
    public void base64Representation() throws UnsupportedEncodingException {
        byte[] bytes = "this-Is_funnY132".getBytes("UTF-8");
        Base64Representation representation = new Base64Representation();
        String actual = representation.toString(bytes);
        Assert.assertEquals((Object)"dGhpcy1Jc19mdW5uWTEzMg==", (Object)actual);
    }

    @Test
    public void hexRepresentation() throws UnsupportedEncodingException {
        byte[] bytes = "this-Is_funnY132".getBytes("UTF-8");
        HexRepresentation representation = new HexRepresentation();
        String actual = representation.toString(bytes);
        Assert.assertEquals((Object)ByteRepresentationsTest.slowConvert(bytes), (Object)actual);
    }

    private static String slowConvert(byte[] bytes) {
        StringBuilder sb = new StringBuilder(bytes.length * 2);
        for (byte b : bytes) {
            sb.append(String.format("%02x", b & 0xFF));
        }
        return sb.toString();
    }
}

