/*
 * Decompiled with CFR 0.152.
 */
package cz.d1x.dxcrypto.encryption;

import cz.d1x.dxcrypto.TestResult;
import cz.d1x.dxcrypto.encryption.ByteAndStringMethodsHaveSameOutput;
import cz.d1x.dxcrypto.encryption.ConcurrencyEncryptionTest;
import cz.d1x.dxcrypto.encryption.EncryptedInputCanBeCorrectlyDecrypted;
import cz.d1x.dxcrypto.encryption.EncryptedInputStreamCanBeCorrectlyDecrypted;
import cz.d1x.dxcrypto.encryption.EncryptedOutputStreamCanBeCorrectlyDecrypted;
import cz.d1x.dxcrypto.encryption.EncryptionAlgorithm;
import cz.d1x.dxcrypto.encryption.EncryptionTest;
import cz.d1x.dxcrypto.encryption.NullInputsThrowIllegalArgumentException;
import cz.d1x.dxcrypto.encryption.SameInputsHaveDifferentOutputForSymmetric;
import java.util.Collection;
import org.junit.Assert;

public abstract class BaseEncryptionTests {
    protected abstract Collection<EncryptionAlgorithm> getAlgorithmsToTest();

    public void nullInputsThrowEncryptionException() {
        this.doTest(new NullInputsThrowIllegalArgumentException());
    }

    public void encryptedInputCanBeCorrectlyDecrypted() {
        this.doTest(new EncryptedInputCanBeCorrectlyDecrypted());
    }

    public void byteAndStringBasedMethodsGiveSameOutput() {
        this.doTest(new ByteAndStringMethodsHaveSameOutput());
    }

    public void sameInputsHaveDifferentOutputsForSymmetricAlgorithms() {
        this.doTest(new SameInputsHaveDifferentOutputForSymmetric());
    }

    public void encryptedInputStreamCanBeCorrectlyDecrypted() {
        this.doTest(new EncryptedInputStreamCanBeCorrectlyDecrypted());
    }

    public void encryptedOutputStreamCanBeCorrectlyDecrypted() {
        this.doTest(new EncryptedOutputStreamCanBeCorrectlyDecrypted());
    }

    public void concurrentEncryptingThreadsDoesNotInterfere() {
        this.doTest(new ConcurrencyEncryptionTest());
    }

    private void doTest(EncryptionTest test) {
        for (EncryptionAlgorithm algorithm : this.getAlgorithmsToTest()) {
            TestResult result = test.test(algorithm);
            if (!result.isFailed()) continue;
            Assert.fail((String)result.getErrorMessage());
        }
    }
}

