/*
 * Decompiled with CFR 0.152.
 */
package cz.d1x.dxcrypto.encryption;

import cz.d1x.dxcrypto.TestResult;
import cz.d1x.dxcrypto.encryption.EncryptionAlgorithm;
import cz.d1x.dxcrypto.encryption.EncryptionTest;
import java.util.Arrays;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class ConcurrencyEncryptionTest
implements EncryptionTest {
    @Override
    public TestResult test(final EncryptionAlgorithm algorithm) {
        int threads = 1000;
        final AtomicBoolean everythingOk = new AtomicBoolean(true);
        final AtomicInteger finishedThreads = new AtomicInteger(0);
        for (int i = 0; i < threads; ++i) {
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        byte[] origInput = new byte[30];
                        new Random().nextBytes(origInput);
                        byte[] output = algorithm.encrypt(origInput);
                        byte[] input = algorithm.decrypt(output);
                        if (!Arrays.equals(input, origInput)) {
                            everythingOk.set(false);
                        }
                    }
                    catch (Exception ex) {
                        System.out.println("Concurrent encryption fails!");
                        everythingOk.set(false);
                    }
                    finishedThreads.incrementAndGet();
                }
            });
            thread.start();
        }
        while (finishedThreads.get() < threads) {
            try {
                Thread.sleep(100L);
                if (everythingOk.get()) continue;
                return TestResult.fail("Any of encryption failed");
            }
            catch (InterruptedException e) {
                return TestResult.fail("Interrupted thread in test");
            }
        }
        return TestResult.success();
    }
}

