/*
 * Decompiled with CFR 0.152.
 */
package cz.d1x.dxcrypto.encryption;

import cz.d1x.dxcrypto.TestResult;
import cz.d1x.dxcrypto.encryption.EncryptionAlgorithm;
import cz.d1x.dxcrypto.encryption.EncryptionTest;
import cz.d1x.dxcrypto.encryption.StreamingEncryptionAlgorithm;
import cz.d1x.dxcrypto.encryption.io.IOUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public class EncryptedOutputStreamCanBeCorrectlyDecrypted
implements EncryptionTest {
    @Override
    public TestResult test(EncryptionAlgorithm algorithm) {
        String decryptedString;
        String plainString = "Som3 T@";
        if (!(algorithm instanceof StreamingEncryptionAlgorithm)) {
            return TestResult.success();
        }
        StreamingEncryptionAlgorithm streamingAlgorithm = (StreamingEncryptionAlgorithm)algorithm;
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try (OutputStream encrypted = streamingAlgorithm.encrypt((OutputStream)output);){
            encrypted.write(plainString.getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            e.printStackTrace();
            return TestResult.fail(e.getMessage());
        }
        byte[] encryptedBytes = output.toByteArray();
        if (new String(encryptedBytes, StandardCharsets.UTF_8).contains(plainString)) {
            return TestResult.fail("Encrypted string contains original string");
        }
        try (InputStream decrypted = streamingAlgorithm.decrypt((InputStream)new ByteArrayInputStream(encryptedBytes));){
            byte[] buffer = new byte[plainString.getBytes(StandardCharsets.UTF_8).length + 2];
            int read = IOUtils.read((InputStream)decrypted, (byte[])buffer);
            decryptedString = new String(Arrays.copyOf(buffer, read), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            e.printStackTrace();
            return TestResult.fail(e.getMessage());
        }
        ByteArrayOutputStream decryptedStream = new ByteArrayOutputStream();
        try (OutputStream decrypted = streamingAlgorithm.decrypt((OutputStream)decryptedStream);){
            decrypted.write(encryptedBytes);
        }
        catch (IOException e) {
            e.printStackTrace();
            return TestResult.fail(e.getMessage());
        }
        if (!new String(decryptedStream.toByteArray(), StandardCharsets.UTF_8).equals(plainString)) {
            return TestResult.fail("Original and decrypted strings does not match");
        }
        if (!decryptedString.equals(plainString)) {
            return TestResult.fail("Original and decrypted strings does not match");
        }
        return TestResult.success();
    }
}

