/*
 * Decompiled with CFR 0.152.
 */
package cz.d1x.dxcrypto.encryption;

import cz.d1x.dxcrypto.encryption.EncryptionAlgorithm;
import cz.d1x.dxcrypto.encryption.EncryptionAlgorithms;
import cz.d1x.dxcrypto.encryption.RSAKeysGenerator;
import cz.d1x.dxcrypto.encryption.key.RSAKeyParams;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class EncryptionAlgorithmsTest {
    private static final byte[] AES_KEY = new byte[]{39, 24, 39, 9, 124, 68, 23, 30, 67, 3, 17, 39, 31, 13, 109, 100};
    private static final byte[] TRIPLE_DES_KEY = new byte[]{39, 24, 39, 9, 124, 68, 23, 30, 67, 3, 17, 39, 31, 13, 109, 100, 68, 24, 39, 9, 122, 68, 23, 62};
    private static final RSAKeyParams[] RSA_KEYS = new RSAKeysGenerator().generateKeys();

    protected List<EncryptionAlgorithm> getImplementationsToTest() {
        return new ArrayList<EncryptionAlgorithm>(){
            {
                this.add(EncryptionAlgorithms.aes((byte[])AES_KEY).build());
                this.add(EncryptionAlgorithms.tripleDes((byte[])TRIPLE_DES_KEY).build());
                this.add(EncryptionAlgorithms.rsa().publicKey(RSA_KEYS[0].getModulus(), RSA_KEYS[0].getExponent()).privateKey(RSA_KEYS[1].getModulus(), RSA_KEYS[1].getExponent()).build());
            }
        };
    }

    @Test
    public void differentInstanceWithSameKeyGiveSameResults() throws UnsupportedEncodingException {
        List<EncryptionAlgorithm> encryptionAlgorithms1 = this.getImplementationsToTest();
        List<EncryptionAlgorithm> encryptionAlgorithms2 = this.getImplementationsToTest();
        String plain = "th1s_is_something inter3sting -*";
        for (int i = 0; i < encryptionAlgorithms1.size(); ++i) {
            EncryptionAlgorithm alg1 = encryptionAlgorithms1.get(i);
            EncryptionAlgorithm alg2 = encryptionAlgorithms2.get(i);
            byte[] plainBytes = plain.getBytes("UTF-8");
            byte[] encryptedBytes = alg1.encrypt(plainBytes);
            byte[] decryptedBytes = alg2.decrypt(encryptedBytes);
            Assert.assertArrayEquals((String)"Original and decrypted strings are not equal", (byte[])plainBytes, (byte[])decryptedBytes);
        }
    }
}

