/*
 * Decompiled with CFR 0.152.
 */
package cz.d1x.dxcrypto.encryption.io;

import cz.d1x.dxcrypto.encryption.EncryptionException;
import cz.d1x.dxcrypto.encryption.io.IvStreamHelper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.junit.Assert;
import org.junit.Test;

public class IvStreamHelperTest {
    private static final byte[] LONG_INPUT_BYTES = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20};
    private final byte[] SHORT_INPUT_BYTES = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10};

    @Test
    public void extractIvReturnsCorrectIv() {
        IvStreamHelper helper = new IvStreamHelper(16);
        ByteArrayInputStream input = new ByteArrayInputStream(LONG_INPUT_BYTES);
        byte[] extractedIv = helper.extractIv((InputStream)input);
        byte[] expectedIv = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
        Assert.assertArrayEquals((byte[])expectedIv, (byte[])extractedIv);
    }

    @Test
    public void extractIvLeavesRestOfTheStreamUntouched() throws IOException {
        IvStreamHelper helper = new IvStreamHelper(16);
        ByteArrayInputStream input = new ByteArrayInputStream(LONG_INPUT_BYTES);
        helper.extractIv((InputStream)input);
        byte[] restOfStreamBuffer = new byte[5];
        Assert.assertEquals((long)5L, (long)input.read(restOfStreamBuffer));
        Assert.assertEquals((long)-1L, (long)input.read());
        Assert.assertArrayEquals((byte[])new byte[]{16, 17, 18, 19, 20}, (byte[])restOfStreamBuffer);
    }

    @Test(expected=EncryptionException.class)
    public void exceptionIsThrownIfStreamIsShorterThanBlockSize() {
        IvStreamHelper helper = new IvStreamHelper(16);
        ByteArrayInputStream input = new ByteArrayInputStream(this.SHORT_INPUT_BYTES);
        helper.extractIv((InputStream)input);
    }

    @Test(expected=EncryptionException.class)
    public void whenReadThrowsExceptionEncryptionExceptionIsThrown() {
        IvStreamHelper helper = new IvStreamHelper(16);
        InputStream input = new InputStream(){

            @Override
            public synchronized int read() throws IOException {
                throw new IOException("You shall not read from this stream.");
            }
        };
        helper.extractIv(input);
    }

    @Test
    public void ivIsWrittenCorrectly() {
        IvStreamHelper helper = new IvStreamHelper(16);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        helper.writeIv((OutputStream)output, this.SHORT_INPUT_BYTES);
        Assert.assertArrayEquals((byte[])this.SHORT_INPUT_BYTES, (byte[])output.toByteArray());
    }

    @Test(expected=EncryptionException.class)
    public void whenWriteThrowsExceptionEncryptionExceptionIsThrown() {
        IvStreamHelper helper = new IvStreamHelper(16);
        OutputStream output = new OutputStream(){

            @Override
            public void write(int b) throws IOException {
                throw new IOException("You shall not write to this stream.");
            }
        };
        helper.writeIv(output, this.SHORT_INPUT_BYTES);
    }
}

