/*
 * Decompiled with CFR 0.152.
 */
package cz.d1x.dxcrypto.performance;

import cz.d1x.dxcrypto.encryption.EncryptionAlgorithm;
import cz.d1x.dxcrypto.encryption.EncryptionAlgorithms;
import cz.d1x.dxcrypto.encryption.StreamingEncryptionAlgorithm;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;

public class EncryptionPerformanceTest {
    private final int ITERATIONS_COUNT = 10000;
    private final int MIN_PLAIN_TEXT_LENGTH = 10;
    private final int MAX_PLAIN_TEXT_LENGTH = 30;
    private final Random RND = new Random();

    @Test
    public void aesPerformance() {
        byte[] keyPassword = new byte[32];
        byte[] keySalt = new byte[16];
        this.RND.nextBytes(keyPassword);
        StreamingEncryptionAlgorithm alg = EncryptionAlgorithms.aes((byte[])keyPassword).keySalt(keySalt).build();
        long avg = this.doTest((EncryptionAlgorithm)alg, "AES");
        Assert.assertTrue((String)"Expecting average encryption time lower than 50ms", (avg < 50L ? 1 : 0) != 0);
    }

    @Test
    public void tripleDesPerformance() {
        byte[] keyPassword = new byte[32];
        byte[] keySalt = new byte[16];
        this.RND.nextBytes(keyPassword);
        StreamingEncryptionAlgorithm alg = EncryptionAlgorithms.tripleDes((byte[])keyPassword).keySalt(keySalt).build();
        long avg = this.doTest((EncryptionAlgorithm)alg, "3DES");
        Assert.assertTrue((String)"Expecting average encryption time lower than 50ms", (avg < 50L ? 1 : 0) != 0);
    }

    private long doTest(EncryptionAlgorithm algorithm, String algName) {
        System.out.println("===> Starting tests of " + algName + " with plain texts of random bytes with length between [" + 10 + "," + 30 + "]");
        long minDuration = Long.MAX_VALUE;
        long maxDuration = Long.MIN_VALUE;
        long durationsSum = 0L;
        for (int i = 0; i < 10000; ++i) {
            int plainTextLength = 10 + this.RND.nextInt(20);
            byte[] plainText = new byte[plainTextLength];
            this.RND.nextBytes(plainText);
            long start = System.currentTimeMillis();
            algorithm.encrypt(plainText);
            long duration = System.currentTimeMillis() - start;
            if (duration > maxDuration) {
                maxDuration = duration;
            }
            if (duration < minDuration) {
                minDuration = duration;
            }
            durationsSum += duration;
        }
        long avgDuration = durationsSum / 10000L;
        System.out.println("===> Results of algorithm " + algName + ": AVG=" + avgDuration + "ms, MIN=" + minDuration + "ms, MAX=" + maxDuration + "ms");
        return avgDuration;
    }
}

