/*
 * Decompiled with CFR 0.152.
 */
package cz.d1x.dxcrypto.props;

import cz.d1x.dxcrypto.encryption.EncryptionAlgorithm;
import cz.d1x.dxcrypto.encryption.EncryptionAlgorithms;
import cz.d1x.dxcrypto.props.SecureProperties;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.junit.Assert;
import org.junit.Test;

public class SecurePropertiesTest {
    private final EncryptionAlgorithm algorithm = EncryptionAlgorithms.aes((String)"mySuperKey").keySalt("andSuperS@lt").build();

    @Test(expected=IllegalArgumentException.class)
    public void nullPrefixThrowsException() {
        new SecureProperties(this.algorithm, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void emptySuffixThrowsException() {
        new SecureProperties(this.algorithm, "");
    }

    @Test(expected=IllegalArgumentException.class)
    public void onlyWhitespacesSuffixThrowsException() {
        new SecureProperties(this.algorithm, " \t ");
    }

    @Test
    public void nonEncryptedValuesWithDefaultSuffix() {
        SecureProperties props = new SecureProperties(this.algorithm);
        props.setProperty("foo", "bar");
        String actual = props.getProperty("foo");
        Assert.assertNotNull((String)"Value under foo must not be null", (Object)actual);
        Assert.assertEquals((Object)"bar", (Object)actual);
    }

    @Test
    public void nonEncryptedValueWithDefaultSuffix() {
        SecureProperties props = new SecureProperties(this.algorithm, "--mySuffix");
        props.setProperty("foo", "bar");
        String actual = props.getProperty("foo");
        Assert.assertNotNull((String)"Value under foo must not be null", (Object)actual);
        Assert.assertEquals((Object)"bar", (Object)actual);
    }

    @Test
    public void nullValuesToBeEncrypted() {
        SecureProperties props = new SecureProperties(this.algorithm);
        try {
            props.setEncryptedProperty("foo", null);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        String actual = props.getProperty("foo");
        Assert.assertNull((Object)actual);
    }

    @Test
    public void emptyValueToBeEncrypted() {
        SecureProperties props = new SecureProperties(this.algorithm);
        props.setEncryptedProperty("foo", "");
        String actual = props.getProperty("foo");
        Assert.assertTrue((boolean)actual.isEmpty());
    }

    @Test
    public void originalPropertyOfNonSetProperty() {
        SecureProperties props = new SecureProperties(this.algorithm);
        String actual = props.getOriginalProperty("foo");
        Assert.assertNull((Object)actual);
    }

    @Test
    public void getPropertyOfNonSetProperty() {
        SecureProperties props = new SecureProperties(this.algorithm);
        String actual = props.getProperty("foo");
        Assert.assertNull((Object)actual);
    }

    @Test
    public void encryptedValuesWithDefaultSuffix() {
        SecureProperties props = new SecureProperties(this.algorithm);
        props.setEncryptedProperty("foo", "bar");
        String actual = props.getProperty("foo");
        Assert.assertNotNull((String)"Value under foo must not be null", (Object)actual);
        Assert.assertEquals((Object)"bar", (Object)actual);
    }

    @Test
    public void encryptedValuesWorkWithCustomSuffix() {
        SecureProperties props = new SecureProperties(this.algorithm, "--mySuffix");
        props.setEncryptedProperty("foo", "bar");
        String actual = props.getProperty("foo");
        Assert.assertNotNull((String)"Value under foo must not be null", (Object)actual);
        Assert.assertEquals((Object)"bar", (Object)actual);
    }

    @Test
    public void valueIsEncryptedInside() {
        SecureProperties props = new SecureProperties(this.algorithm, "--mySuffix");
        props.setEncryptedProperty("foo", "bar");
        String encryptedValue = props.getOriginalProperty("foo");
        Assert.assertTrue((boolean)encryptedValue.endsWith("--mySuffix"));
        String encryptedValueNoSuffix = encryptedValue.substring(0, encryptedValue.length() - "--mySuffix".length());
        Assert.assertEquals((long)64L, (long)encryptedValueNoSuffix.length());
    }

    @Test
    public void valuesAreEncryptedWhenStored() throws IOException {
        SecureProperties props = new SecureProperties(this.algorithm, "--mySuffix");
        props.setEncryptedProperty("foo", "bar");
        StringWriter sw = new StringWriter();
        props.store((Writer)sw, null);
        String[] propsStrings = sw.toString().split("\r?\n");
        Assert.assertTrue((propsStrings.length >= 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)propsStrings[1].endsWith("--mySuffix"));
        String encryptedValue = propsStrings[1].substring(0, propsStrings[1].length() - "foo=--mySuffix".length());
        Assert.assertEquals((long)64L, (long)encryptedValue.length());
    }

    @Test
    public void validateWithNonExistentValues() {
        SecureProperties props = new SecureProperties(this.algorithm, "--mySuffix");
        Assert.assertTrue((boolean)props.validateValue("foo", null));
        Assert.assertFalse((boolean)props.validateValue("foo", ""));
    }

    @Test
    public void validateWithNonNullValues() {
        SecureProperties props = new SecureProperties(this.algorithm, "--mySuffix");
        props.setProperty("foo", "bar");
        Assert.assertTrue((boolean)props.validateValue("foo", "bar"));
        Assert.assertFalse((boolean)props.validateValue("foo", "barr"));
    }
}

