/*
 * Decompiled with CFR 0.152.
 */
package cz.d1x.dxcrypto.encryption.io;

import cz.d1x.dxcrypto.encryption.StreamingEncryptionEngine;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicInteger;

public class DecryptingOutputStream
extends FilterOutputStream {
    private final StreamingEncryptionEngine engine;
    private final byte[] ivBuffer;
    private final AtomicInteger ivWritePosition = new AtomicInteger();
    private OutputStream decryptingStream;

    public DecryptingOutputStream(OutputStream out, StreamingEncryptionEngine engine, int blockSize) {
        super(out);
        this.engine = engine;
        this.ivBuffer = new byte[blockSize];
    }

    @Override
    public void write(int b) throws IOException {
        int currentWritePosition = this.ivWritePosition.get();
        if (currentWritePosition < this.ivBuffer.length) {
            this.ivBuffer[this.ivWritePosition.getAndIncrement()] = (byte)b;
            if (this.ivWritePosition.get() == this.ivBuffer.length) {
                this.decryptingStream = this.engine.decrypt(this.out, this.ivBuffer);
            }
        } else {
            this.decryptingStream.write(b);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.decryptingStream != null) {
            this.decryptingStream.close();
        }
        super.close();
    }
}

