/*
 * Decompiled with CFR 0.152.
 */
package cz.d1x.dxcrypto.encryption.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicInteger;

public class EncryptingInputStream
extends FilterInputStream {
    private final byte[] iv;
    private AtomicInteger ivReadPosition = new AtomicInteger();

    public EncryptingInputStream(InputStream in, byte[] iv) {
        super(in);
        this.iv = iv;
    }

    @Override
    public int read() throws IOException {
        if (this.ivReadPosition.get() < this.iv.length) {
            return this.iv[this.ivReadPosition.getAndIncrement()];
        }
        return super.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.ivReadPosition.get() < this.iv.length) {
            int copyLength = Math.min(len, this.iv.length - this.ivReadPosition.get());
            System.arraycopy(this.iv, this.ivReadPosition.getAndAdd(copyLength), b, off, copyLength);
            return copyLength;
        }
        return super.read(b, off, len);
    }

    @Override
    public long skip(long n) {
        throw new UnsupportedOperationException("Skip is not supported.");
    }

    @Override
    public int available() throws IOException {
        return this.iv.length - this.ivReadPosition.get() + super.available();
    }

    @Override
    public synchronized void mark(int readlimit) {
    }

    @Override
    public synchronized void reset() {
    }

    @Override
    public boolean markSupported() {
        return false;
    }
}

