/*
 * Decompiled with CFR 0.152.
 */
package cz.d1x.dxcrypto;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import javax.xml.bind.DatatypeConverter;

public class Encoding {
    public static final String DEFAULT = "UTF-8";

    public static String toHex(byte[] bytes) throws IllegalArgumentException {
        if (bytes == null) {
            throw new IllegalArgumentException("Input bytes cannot be null when converted to HEX format");
        }
        try {
            return DatatypeConverter.printHexBinary((byte[])bytes).toLowerCase();
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Input HEX cannot be converted to bytes", e);
        }
    }

    public static byte[] fromHex(String hex) throws IllegalArgumentException {
        if (hex == null) {
            throw new IllegalArgumentException("Input HEX cannot be null when converted to bytes");
        }
        try {
            return DatatypeConverter.parseHexBinary((String)hex.toLowerCase());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Input HEX cannot be converted to bytes", e);
        }
    }

    public static void checkEncoding(String encoding) throws IllegalArgumentException {
        boolean isSupported;
        try {
            isSupported = Charset.isSupported(encoding);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Given encoding " + encoding + " is not supported");
        }
        if (!isSupported) {
            throw new IllegalArgumentException("Given encoding " + encoding + " is not supported");
        }
    }

    public static byte[] getBytes(String text, String encoding) throws IllegalArgumentException {
        if (text == null) {
            throw new IllegalArgumentException("Given text cannot be null");
        }
        try {
            return text.getBytes(encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("Given encoding " + encoding + " is not supported");
        }
    }

    public static byte[] getBytes(String text) {
        return Encoding.getBytes(text, DEFAULT);
    }

    public static String getString(byte[] text, String encoding) throws IllegalArgumentException {
        if (text == null) {
            throw new IllegalArgumentException("Given text bytes cannot be null");
        }
        try {
            return new String(text, encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("Given encoding " + encoding + " is not supported");
        }
    }

    public static String getString(byte[] text) {
        return Encoding.getString(text, DEFAULT);
    }
}

