/*
 * Decompiled with CFR 0.152.
 */
package cz.d1x.dxcrypto.encryption.crypto;

import cz.d1x.dxcrypto.Encoding;
import cz.d1x.dxcrypto.encryption.EncryptionAlgorithm;
import cz.d1x.dxcrypto.encryption.EncryptionException;
import cz.d1x.dxcrypto.encryption.crypto.CryptoKeyFactory;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;

public class AsymmetricAlgorithm
implements EncryptionAlgorithm {
    private final String cipherName;
    private final Key publicKey;
    private final Key privateKey;
    private final String encoding;

    protected AsymmetricAlgorithm(String cipherName, CryptoKeyFactory publicKeyFactory, CryptoKeyFactory privateKeyFactory, String encoding) {
        Encoding.checkEncoding(encoding);
        if (publicKeyFactory == null && privateKeyFactory == null) {
            throw new EncryptionException("At least one (public/private) key factory must be set");
        }
        this.encoding = encoding;
        try {
            Cipher.getInstance(cipherName);
            this.cipherName = cipherName;
            this.publicKey = publicKeyFactory != null ? (Key)publicKeyFactory.getKey() : null;
            this.privateKey = privateKeyFactory != null ? (Key)privateKeyFactory.getKey() : null;
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new EncryptionException("Invalid encryption algorithm", e);
        }
    }

    @Override
    public byte[] encrypt(byte[] input) throws EncryptionException {
        this.checkKey(true);
        try {
            Cipher cipher = this.initCipher(true);
            return cipher.doFinal(input);
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            throw new EncryptionException("Unable to encrypt message", e);
        }
    }

    @Override
    public String encrypt(String input) throws EncryptionException {
        byte[] textBytes = Encoding.getBytes(input, this.encoding);
        byte[] encryptedBytes = this.encrypt(textBytes);
        return Encoding.toHex(encryptedBytes);
    }

    @Override
    public byte[] decrypt(byte[] input) throws EncryptionException {
        this.checkKey(false);
        try {
            Cipher cipher = this.initCipher(false);
            return cipher.doFinal(input);
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            throw new EncryptionException("Unable to decrypt message", e);
        }
    }

    @Override
    public String decrypt(String input) throws EncryptionException {
        byte[] textBytes = Encoding.fromHex(input);
        byte[] decryptedBytes = this.decrypt(textBytes);
        return Encoding.getString(decryptedBytes, this.encoding);
    }

    private Cipher initCipher(boolean isEncrypt) throws EncryptionException {
        try {
            Cipher cipher = Cipher.getInstance(this.cipherName);
            cipher.init(isEncrypt ? 1 : 2, isEncrypt ? this.publicKey : this.privateKey);
            return cipher;
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new EncryptionException("Unable to initialize cipher", e);
        }
    }

    private void checkKey(boolean isPublic) throws EncryptionException {
        if (isPublic && this.publicKey == null) {
            throw new EncryptionException("You didn't set public key during initialization, unable to encrypt messages");
        }
        if (!isPublic && this.privateKey == null) {
            throw new EncryptionException("You didn't set private key during initialization, unable to decrypt messages");
        }
    }
}

