/*
 * Decompiled with CFR 0.152.
 */
package cz.d1x.dxcrypto.encryption.crypto;

import cz.d1x.dxcrypto.Encoding;
import cz.d1x.dxcrypto.common.CombineAlgorithm;
import cz.d1x.dxcrypto.encryption.EncryptionAlgorithm;
import cz.d1x.dxcrypto.encryption.EncryptionException;
import cz.d1x.dxcrypto.encryption.crypto.CryptoKeyFactory;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;

public class SymmetricAlgorithm
implements EncryptionAlgorithm {
    private final SecureRandom random = new SecureRandom();
    private final String cipherName;
    private final int blockSize;
    private final Key key;
    private final CombineAlgorithm combineAlgorithm;
    private final String encoding;

    public SymmetricAlgorithm(String cipherName, CryptoKeyFactory keyFactory, CombineAlgorithm combineAlgorithm, String encoding) throws EncryptionException {
        Encoding.checkEncoding(encoding);
        if (keyFactory == null) {
            throw new EncryptionException("Key factory must be set");
        }
        this.encoding = encoding;
        try {
            Cipher cipher = Cipher.getInstance(cipherName);
            this.cipherName = cipherName;
            this.blockSize = cipher.getBlockSize();
            this.key = (Key)keyFactory.getKey();
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new EncryptionException("Invalid encryption algorithm", e);
        }
        this.combineAlgorithm = combineAlgorithm;
    }

    @Override
    public byte[] encrypt(byte[] input) throws EncryptionException {
        try {
            IvParameterSpec iv = this.generateIV();
            Cipher cipher = this.initCipher(iv, true);
            byte[] encryptedBytes = cipher.doFinal(input);
            return this.combineAlgorithm.combine(iv.getIV(), encryptedBytes);
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            throw new EncryptionException("Unable to encrypt input", e);
        }
    }

    @Override
    public String encrypt(String input) throws EncryptionException {
        byte[] textBytes = Encoding.getBytes(input, this.encoding);
        byte[] encryptedBytes = this.encrypt(textBytes);
        return Encoding.toHex(encryptedBytes);
    }

    @Override
    public byte[] decrypt(byte[] input) throws EncryptionException {
        try {
            byte[][] ivAndCipherText = this.combineAlgorithm.split(input);
            IvParameterSpec iv = new IvParameterSpec(ivAndCipherText[0]);
            Cipher cipher = this.initCipher(iv, false);
            return cipher.doFinal(ivAndCipherText[1]);
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            throw new EncryptionException("Unable to decrypt input", e);
        }
    }

    @Override
    public String decrypt(String input) throws EncryptionException {
        byte[] textBytes = Encoding.fromHex(input);
        byte[] decryptedBytes = this.decrypt(textBytes);
        return Encoding.getString(decryptedBytes, this.encoding);
    }

    private IvParameterSpec generateIV() {
        byte[] iv = new byte[this.blockSize];
        this.random.nextBytes(iv);
        return new IvParameterSpec(iv);
    }

    private Cipher initCipher(IvParameterSpec iv, boolean isEncrypt) throws EncryptionException {
        try {
            Cipher cipher = Cipher.getInstance(this.cipherName);
            cipher.init(isEncrypt ? 1 : 2, this.key, iv);
            return cipher;
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new EncryptionException("Unable to initialize cipher", e);
        }
    }
}

