/*
 * Decompiled with CFR 0.152.
 */
package cz.d1x.dxcrypto.encryption.crypto;

import cz.d1x.dxcrypto.Encoding;
import cz.d1x.dxcrypto.common.CombineAlgorithm;
import cz.d1x.dxcrypto.common.ConcatCombineAlgorithm;
import cz.d1x.dxcrypto.encryption.EncryptionAlgorithm;
import cz.d1x.dxcrypto.encryption.EncryptionAlgorithmBuilder;
import cz.d1x.dxcrypto.encryption.EncryptionException;
import cz.d1x.dxcrypto.encryption.crypto.CryptoKeyFactory;
import cz.d1x.dxcrypto.encryption.crypto.PBKDF2KeyFactory;
import cz.d1x.dxcrypto.encryption.crypto.SymmetricAlgorithm;

public abstract class SymmetricAlgorithmBuilder
implements EncryptionAlgorithmBuilder {
    private static final byte[] DEFAULT_KEY_SALT = new byte[]{39, 17, 101, 53, 19, 119, 51, 33, 64, 67, 24, 101};
    private static final int DEFAULT_KEY_HASH_ITERATIONS = 4096;
    private CryptoKeyFactory customKeyFactory;
    private byte[] keyPassword;
    private byte[] keySalt;
    private int keyHashIterations;
    private CombineAlgorithm combineAlgorithm;
    private String encoding;

    protected abstract String getAlgorithm();

    protected abstract String getShortAlgorithm();

    protected abstract int getKeySize();

    protected abstract int getBlockSize();

    protected SymmetricAlgorithmBuilder(byte[] keyPassword) {
        this.keyPassword = keyPassword;
    }

    protected SymmetricAlgorithmBuilder(String keyPassword) {
        this.keyPassword = Encoding.getBytes(keyPassword);
    }

    protected SymmetricAlgorithmBuilder(CryptoKeyFactory customKeyFactory) {
        this.customKeyFactory = customKeyFactory;
    }

    public SymmetricAlgorithmBuilder keySalt(byte[] keySalt) {
        this.keySalt = keySalt;
        return this;
    }

    public SymmetricAlgorithmBuilder keySalt(String keySalt) {
        this.keySalt = Encoding.getBytes(keySalt);
        return this;
    }

    public SymmetricAlgorithmBuilder keyHashIterations(int keyHashIterations) {
        this.keyHashIterations = keyHashIterations;
        return this;
    }

    public SymmetricAlgorithmBuilder combineAlgorithm(CombineAlgorithm combineAlgorithm) {
        this.combineAlgorithm = combineAlgorithm;
        return this;
    }

    public SymmetricAlgorithmBuilder encoding(String encoding) {
        this.encoding = encoding;
        return this;
    }

    @Override
    public EncryptionAlgorithm build() throws EncryptionException {
        CryptoKeyFactory keyFactory;
        if (this.encoding == null) {
            this.encoding = "UTF-8";
        }
        if (this.combineAlgorithm == null) {
            this.combineAlgorithm = new ConcatCombineAlgorithm(this.getBlockSize());
        }
        if (this.customKeyFactory != null) {
            keyFactory = this.customKeyFactory;
        } else {
            if (this.keySalt == null) {
                this.keySalt = DEFAULT_KEY_SALT;
            }
            if (this.keyHashIterations == 0) {
                this.keyHashIterations = 4096;
            }
            keyFactory = new PBKDF2KeyFactory(this.getShortAlgorithm(), this.keyPassword, this.getKeySize(), this.keySalt, this.keyHashIterations);
        }
        return new SymmetricAlgorithm(this.getAlgorithm(), keyFactory, this.combineAlgorithm, this.encoding);
    }
}

