/*
 * Decompiled with CFR 0.152.
 */
package cz.d1x.dxcrypto.hash;

import cz.d1x.dxcrypto.common.CombineAlgorithm;
import cz.d1x.dxcrypto.common.ConcatCombineAlgorithm;
import cz.d1x.dxcrypto.hash.HashingAlgorithm;
import cz.d1x.dxcrypto.hash.SaltingAdapter;

public class SaltingAdapterBuilder {
    private static final CombineAlgorithm DEFAULT_COMBINE_ALGORITHM = new ConcatCombineAlgorithm();
    private final HashingAlgorithm hashingAlgorithm;
    private CombineAlgorithm combineAlgorithm;
    private String encoding;

    public SaltingAdapterBuilder(HashingAlgorithm hashingAlgorithm) {
        this.hashingAlgorithm = hashingAlgorithm;
    }

    public SaltingAdapterBuilder(HashingAlgorithm hashingAlgorithm, String encoding) {
        this.hashingAlgorithm = hashingAlgorithm;
        this.encoding = encoding;
    }

    public SaltingAdapterBuilder combineAlgorithm(CombineAlgorithm combineAlgorithm) {
        this.combineAlgorithm = combineAlgorithm;
        return this;
    }

    public SaltingAdapterBuilder encoding(String encoding) {
        this.encoding = encoding;
        return this;
    }

    public SaltingAdapter build() {
        if (this.encoding == null) {
            this.encoding = "UTF-8";
        }
        if (this.combineAlgorithm == null) {
            this.combineAlgorithm = DEFAULT_COMBINE_ALGORITHM;
        }
        return new SaltingAdapter(this.hashingAlgorithm, this.combineAlgorithm, this.encoding);
    }
}

