/*
 * Decompiled with CFR 0.152.
 */
package cz.d1x.dxcrypto.hash.digest;

import cz.d1x.dxcrypto.common.CombineAlgorithm;
import cz.d1x.dxcrypto.encryption.EncryptionException;
import cz.d1x.dxcrypto.hash.HashingAlgorithm;
import cz.d1x.dxcrypto.hash.HashingAlgorithmBuilder;
import cz.d1x.dxcrypto.hash.RepeatingDecoratorBuilder;
import cz.d1x.dxcrypto.hash.SaltingAdapterBuilder;
import cz.d1x.dxcrypto.hash.digest.DigestAlgorithm;

public abstract class DigestAlgorithmBuilder
implements HashingAlgorithmBuilder {
    private String encoding;

    protected DigestAlgorithmBuilder() {
    }

    protected abstract String getAlgorithm();

    public DigestAlgorithmBuilder encoding(String encoding) {
        this.encoding = encoding;
        return this;
    }

    public SaltingAdapterBuilder salted() {
        HashingAlgorithm alg = this.build();
        return new SaltingAdapterBuilder(alg, this.encoding).encoding(this.encoding);
    }

    public SaltingAdapterBuilder salted(CombineAlgorithm combineAlgorithm) {
        HashingAlgorithm alg = this.build();
        return new SaltingAdapterBuilder(alg, this.encoding).combineAlgorithm(combineAlgorithm).encoding(this.encoding);
    }

    public RepeatingDecoratorBuilder repeated(int repeats) {
        HashingAlgorithm alg = this.build();
        return new RepeatingDecoratorBuilder(alg).repeats(repeats);
    }

    @Override
    public HashingAlgorithm build() throws EncryptionException {
        if (this.encoding == null) {
            this.encoding = "UTF-8";
        }
        return new DigestAlgorithm(this.getAlgorithm(), this.encoding);
    }
}

