/*
 * Decompiled with CFR 0.152.
 */
package cz.d1x.dxcrypto.encryption;

import cz.d1x.dxcrypto.common.Encoding;
import cz.d1x.dxcrypto.encryption.EncryptionEnginesFactories;
import cz.d1x.dxcrypto.encryption.RSAAlgorithmBuilder;
import cz.d1x.dxcrypto.encryption.SymmetricAlgorithmBuilder;
import cz.d1x.dxcrypto.encryption.SymmetricEncryptionEngineFactory;
import cz.d1x.dxcrypto.encryption.crypto.CryptoEnginesFactories;
import cz.d1x.dxcrypto.encryption.crypto.RSACryptoEngineFactory;

public class EncryptionAlgorithms {
    private static EncryptionEnginesFactories defaultFactories = new CryptoEnginesFactories();

    public static void defaultFactories(EncryptionEnginesFactories factories) {
        if (factories == null) {
            throw new IllegalArgumentException("You must provide non-null engine factories!");
        }
        defaultFactories = factories;
    }

    public static SymmetricAlgorithmBuilder aes(byte[] keyPassword) throws IllegalArgumentException {
        SymmetricEncryptionEngineFactory engineFactory = defaultFactories.aes();
        return new SymmetricAlgorithmBuilder(engineFactory, keyPassword, 128, 128);
    }

    public static SymmetricAlgorithmBuilder aes(String keyPassword) throws IllegalArgumentException {
        return EncryptionAlgorithms.aes(Encoding.getBytes(keyPassword));
    }

    public static SymmetricAlgorithmBuilder aes256(byte[] keyPassword) throws IllegalArgumentException {
        SymmetricEncryptionEngineFactory engineFactory = defaultFactories.aes256();
        return new SymmetricAlgorithmBuilder(engineFactory, keyPassword, 256, 128);
    }

    public static SymmetricAlgorithmBuilder aes256(String keyPassword) throws IllegalArgumentException {
        return EncryptionAlgorithms.aes256(Encoding.getBytes(keyPassword));
    }

    public static SymmetricAlgorithmBuilder tripleDes(byte[] keyPassword) throws IllegalArgumentException {
        int keySize = 192;
        SymmetricEncryptionEngineFactory engineFactory = defaultFactories.tripleDes();
        return new SymmetricAlgorithmBuilder(engineFactory, keyPassword, keySize, 64);
    }

    public static SymmetricAlgorithmBuilder tripleDes(String keyPassword) throws IllegalArgumentException {
        return EncryptionAlgorithms.tripleDes(Encoding.getBytes(keyPassword));
    }

    public static RSAAlgorithmBuilder rsa() {
        RSACryptoEngineFactory factory = defaultFactories.rsa();
        return new RSAAlgorithmBuilder(factory);
    }
}

