/*
 * Decompiled with CFR 0.152.
 */
package cz.d1x.dxcrypto.encryption;

import cz.d1x.dxcrypto.common.ByteArrayFactory;
import cz.d1x.dxcrypto.common.BytesRepresentation;
import cz.d1x.dxcrypto.common.CombiningSplitting;
import cz.d1x.dxcrypto.common.ConcatAlgorithm;
import cz.d1x.dxcrypto.common.Encoding;
import cz.d1x.dxcrypto.common.HexRepresentation;
import cz.d1x.dxcrypto.common.RandomByteArrayFactory;
import cz.d1x.dxcrypto.encryption.EncryptionAlgorithm;
import cz.d1x.dxcrypto.encryption.EncryptionEngine;
import cz.d1x.dxcrypto.encryption.GenericEncryptionAlgorithm;
import cz.d1x.dxcrypto.encryption.SymmetricEncryptionEngineFactory;

public final class SymmetricAlgorithmBuilder {
    private static final byte[] DEFAULT_KEY_SALT = new byte[]{39, 17, 101, 53, 19, 119, 51, 33, 64, 67, 24, 101};
    private static final int DEFAULT_KEY_HASH_ITERATIONS = 4096;
    private SymmetricEncryptionEngineFactory engineFactory;
    private int blockSize;
    private final int keySize;
    private final byte[] keyPassword;
    private byte[] keySalt = DEFAULT_KEY_SALT;
    private int keyHashIterations = 4096;
    private BytesRepresentation bytesRepresentation = new HexRepresentation();
    private String encoding = "UTF-8";
    private ByteArrayFactory ivFactory = new RandomByteArrayFactory();
    private CombiningSplitting ivOutputCombining;

    public SymmetricAlgorithmBuilder(SymmetricEncryptionEngineFactory engineFactory, byte[] keyPassword, int keySize, int blockSize) {
        if (keyPassword == null) {
            throw new IllegalArgumentException("You must provide non-null key password!");
        }
        this.blockSize = blockSize / 8;
        this.keySize = keySize;
        this.keyPassword = keyPassword;
        this.engineFactory = engineFactory;
        this.ivOutputCombining = new ConcatAlgorithm(this.blockSize);
    }

    public SymmetricAlgorithmBuilder engineFactory(SymmetricEncryptionEngineFactory engineFactory) throws IllegalArgumentException {
        if (engineFactory == null) {
            throw new IllegalArgumentException("You must provide non-null engine factory!");
        }
        this.engineFactory = engineFactory;
        return this;
    }

    public SymmetricAlgorithmBuilder keySalt(byte[] keySalt) throws IllegalArgumentException {
        if (keySalt == null) {
            throw new IllegalArgumentException("You must provide non-null key salt!");
        }
        this.keySalt = keySalt;
        return this;
    }

    public SymmetricAlgorithmBuilder keySalt(String keySalt) throws IllegalArgumentException {
        if (keySalt == null) {
            throw new IllegalArgumentException("You must provide non-null key salt!");
        }
        return this.keySalt(Encoding.getBytes(keySalt));
    }

    public SymmetricAlgorithmBuilder keyHashIterations(int keyHashIterations) throws IllegalArgumentException {
        if (keyHashIterations < 1) {
            throw new IllegalArgumentException("You must provide iterations >= 1!");
        }
        this.keyHashIterations = keyHashIterations;
        return this;
    }

    public SymmetricAlgorithmBuilder ivFactory(ByteArrayFactory ivFactory) throws IllegalArgumentException {
        if (ivFactory == null) {
            throw new IllegalArgumentException("You must provide non-null ByteArrayFactory!");
        }
        this.ivFactory = ivFactory;
        return this;
    }

    public SymmetricAlgorithmBuilder ivAndOutputCombining(CombiningSplitting ivOutputCombining) throws IllegalArgumentException {
        if (ivOutputCombining == null) {
            throw new IllegalArgumentException("You must provide non-null CombiningSplitting!");
        }
        this.ivOutputCombining = ivOutputCombining;
        return this;
    }

    public SymmetricAlgorithmBuilder bytesRepresentation(BytesRepresentation bytesRepresentation) throws IllegalArgumentException {
        if (bytesRepresentation == null) {
            throw new IllegalArgumentException("You must provide non-null BytesRepresentation!");
        }
        this.bytesRepresentation = bytesRepresentation;
        return this;
    }

    public SymmetricAlgorithmBuilder encoding(String encoding) throws IllegalArgumentException {
        if (encoding == null) {
            throw new IllegalArgumentException("You must provide non-null encoding!");
        }
        Encoding.checkEncoding(encoding);
        this.encoding = encoding;
        return this;
    }

    public EncryptionAlgorithm build() throws IllegalArgumentException {
        EncryptionEngine engine = this.engineFactory.newEngine(this.keyPassword, this.keySalt, this.keyHashIterations, this.keySize);
        return new GenericEncryptionAlgorithm(engine, this.bytesRepresentation, this.encoding, this.blockSize, this.ivFactory, this.ivOutputCombining);
    }
}

