/*
 * Decompiled with CFR 0.152.
 */
package cz.d1x.dxcrypto.encryption.crypto;

import cz.d1x.dxcrypto.encryption.EncryptionEngine;
import cz.d1x.dxcrypto.encryption.EncryptionException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;

public class AsymmetricCryptoEngine
implements EncryptionEngine {
    private final String cipherName;
    private final Key encryptionKey;
    private final Key decryptionKey;

    public AsymmetricCryptoEngine(String cipherName, Key encryptionKey, Key decryptionKey) {
        this.cipherName = cipherName;
        this.encryptionKey = encryptionKey;
        this.decryptionKey = decryptionKey;
        try {
            Cipher.getInstance(cipherName);
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new EncryptionException("Invalid encryption algorithm", e);
        }
    }

    @Override
    public byte[] encrypt(byte[] input, byte[] initVector) throws EncryptionException {
        if (this.encryptionKey == null) {
            throw new EncryptionException("You didn't set public key during initialization, unable to encrypt messages");
        }
        return this.doOperation(input, true);
    }

    @Override
    public byte[] decrypt(byte[] input, byte[] initVector) throws EncryptionException {
        if (this.decryptionKey == null) {
            throw new EncryptionException("You didn't set private key during initialization, unable to decrypt messages");
        }
        return this.doOperation(input, false);
    }

    private byte[] doOperation(byte[] input, boolean isEncrypt) {
        try {
            Cipher cipher = Cipher.getInstance(this.cipherName);
            cipher.init(isEncrypt ? 1 : 2, isEncrypt ? this.encryptionKey : this.decryptionKey);
            return cipher.doFinal(input);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new EncryptionException("Unable to initialize cipher", e);
        }
    }
}

