/*
 * Decompiled with CFR 0.152.
 */
package cz.d1x.dxcrypto.encryption.crypto;

import cz.d1x.dxcrypto.encryption.EncryptionEngine;
import cz.d1x.dxcrypto.encryption.EncryptionException;
import cz.d1x.dxcrypto.encryption.RSAEngineFactory;
import cz.d1x.dxcrypto.encryption.crypto.AsymmetricCryptoEngine;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;

public class RSACryptoEngineFactory
implements RSAEngineFactory {
    private final String algorithmName;

    public RSACryptoEngineFactory(String algorithmName) {
        this.algorithmName = algorithmName;
    }

    @Override
    public EncryptionEngine newEngine(BigInteger modulus, BigInteger publicExponent, BigInteger privateExponent) {
        try {
            String shortAlgorithmName = this.algorithmName.contains("/") ? this.algorithmName.substring(0, this.algorithmName.indexOf("/")) : this.algorithmName;
            KeyFactory keyFactory = KeyFactory.getInstance(shortAlgorithmName);
            PublicKey publicKey = null;
            PrivateKey privateKey = null;
            if (publicExponent != null) {
                RSAPublicKeySpec pubKeySpec = new RSAPublicKeySpec(modulus, publicExponent);
                publicKey = keyFactory.generatePublic(pubKeySpec);
            }
            if (privateExponent != null) {
                RSAPrivateKeySpec privKeySpec = new RSAPrivateKeySpec(modulus, privateExponent);
                privateKey = keyFactory.generatePrivate(privKeySpec);
            }
            return new AsymmetricCryptoEngine(this.algorithmName, publicKey, privateKey);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new EncryptionException("Unable to retrieve RSA public key", e);
        }
    }
}

