/*
 * Decompiled with CFR 0.152.
 */
package cz.d1x.dxcrypto.encryption.crypto;

import cz.d1x.dxcrypto.common.Encoding;
import cz.d1x.dxcrypto.encryption.EncryptionEngine;
import cz.d1x.dxcrypto.encryption.EncryptionException;
import cz.d1x.dxcrypto.encryption.SymmetricEncryptionEngineFactory;
import cz.d1x.dxcrypto.encryption.crypto.CryptoEnginesFactories;
import cz.d1x.dxcrypto.encryption.crypto.SymmetricCryptoEngine;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;

public class SymmetricCryptoEngineFactory
implements SymmetricEncryptionEngineFactory {
    private final String algorithmName;
    private final String keyAlgorithmName;

    public SymmetricCryptoEngineFactory(String algorithmName, String keyAlgorithmName) {
        this.algorithmName = algorithmName;
        this.keyAlgorithmName = keyAlgorithmName;
    }

    @Override
    public EncryptionEngine newEngine(byte[] keyPassword, byte[] keySalt, int keyHashIterations, int keySize) {
        String shortAlgorithmName;
        String string = shortAlgorithmName = this.algorithmName.contains("/") ? this.algorithmName.substring(0, this.algorithmName.indexOf("/")) : this.algorithmName;
        if ("AES".equals(shortAlgorithmName) && keySize >= 256) {
            this.checkJCE("AES", 256);
        }
        try {
            char[] keyEncoded = Encoding.getString(keyPassword).toCharArray();
            PBEKeySpec keySpec = new PBEKeySpec(keyEncoded, keySalt, keyHashIterations, keySize);
            SecretKey tmp = SecretKeyFactory.getInstance(this.keyAlgorithmName).generateSecret(keySpec);
            SecretKeySpec key = new SecretKeySpec(tmp.getEncoded(), shortAlgorithmName);
            return new SymmetricCryptoEngine(this.algorithmName, key);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new EncryptionException("Invalid key derivation algorithm", e);
        }
    }

    private void checkJCE(String name, int keySize) {
        if (!CryptoEnginesFactories.isJceInstalled()) {
            throw new IllegalArgumentException("Cipher " + name + " is not supported with key size of " + keySize + "b,  probably Java Cryptography Extension (JCE) is not installed in your Java.");
        }
    }
}

