/*
 * Decompiled with CFR 0.152.
 */
package cz.d1x.dxcrypto.hash;

import cz.d1x.dxcrypto.common.CombineAlgorithm;
import cz.d1x.dxcrypto.hash.HashingAlgorithm;
import cz.d1x.dxcrypto.hash.HashingAlgorithmBuilder;
import cz.d1x.dxcrypto.hash.RepeatingDecorator;
import cz.d1x.dxcrypto.hash.SaltingAdapterBuilder;

public class RepeatingDecoratorBuilder
implements HashingAlgorithmBuilder {
    private final HashingAlgorithm hashingAlgorithm;
    private int repeats = -1;

    public RepeatingDecoratorBuilder(HashingAlgorithm hashingAlgorithm) {
        this.hashingAlgorithm = hashingAlgorithm;
    }

    public RepeatingDecoratorBuilder repeats(int repeats) {
        if (repeats < 1) {
            throw new IllegalArgumentException("Expecting at least 1 repeat");
        }
        this.repeats = repeats;
        return this;
    }

    public SaltingAdapterBuilder salted() {
        RepeatingDecorator alg = this.build();
        return new SaltingAdapterBuilder(alg);
    }

    public SaltingAdapterBuilder salted(CombineAlgorithm combineAlgorithm) {
        RepeatingDecorator alg = this.build();
        return new SaltingAdapterBuilder(alg).combineAlgorithm(combineAlgorithm);
    }

    @Override
    public RepeatingDecorator build() {
        return new RepeatingDecorator(this.hashingAlgorithm, this.repeats);
    }
}

