/*
 * Decompiled with CFR 0.152.
 */
package cz.d1x.dxcrypto.hash.digest;

import cz.d1x.dxcrypto.common.BytesRepresentation;
import cz.d1x.dxcrypto.common.Encoding;
import cz.d1x.dxcrypto.hash.HashingAlgorithm;
import cz.d1x.dxcrypto.hash.HashingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public final class DigestAlgorithm
implements HashingAlgorithm {
    private final String digestName;
    private final BytesRepresentation bytesRepresentation;
    private final String encoding;

    protected DigestAlgorithm(String digestName, BytesRepresentation bytesRepresentation, String encoding) {
        Encoding.checkEncoding(encoding);
        this.bytesRepresentation = bytesRepresentation;
        this.encoding = encoding;
        try {
            MessageDigest.getInstance(digestName);
            this.digestName = digestName;
        }
        catch (NoSuchAlgorithmException ex) {
            throw new HashingException(ex);
        }
    }

    @Override
    public byte[] hash(byte[] input) throws HashingException {
        MessageDigest digest;
        if (input == null) {
            throw new HashingException("Input data for hashing cannot be null");
        }
        try {
            digest = MessageDigest.getInstance(this.digestName);
        }
        catch (NoSuchAlgorithmException e) {
            throw new HashingException("Unable to get instance of digest " + this.digestName, e);
        }
        digest.reset();
        return digest.digest(input);
    }

    @Override
    public String hash(String input) throws HashingException {
        if (input == null) {
            throw new HashingException("Input data for hashing cannot be null");
        }
        byte[] textBytes = Encoding.getBytes(input, this.encoding);
        byte[] hash = this.hash(textBytes);
        return this.bytesRepresentation.toString(hash);
    }
}

