/*
 * Decompiled with CFR 0.152.
 */
package cz.d1x.dxcrypto.encryption.crypto;

import cz.d1x.dxcrypto.common.BytesRepresentation;
import cz.d1x.dxcrypto.common.HexRepresentation;
import cz.d1x.dxcrypto.encryption.EncryptionAlgorithm;
import cz.d1x.dxcrypto.encryption.EncryptionAlgorithmBuilder;
import cz.d1x.dxcrypto.encryption.EncryptionException;
import cz.d1x.dxcrypto.encryption.crypto.AsymmetricAlgorithm;
import cz.d1x.dxcrypto.encryption.crypto.CryptoKeyFactory;
import cz.d1x.dxcrypto.encryption.crypto.RSAPrivateKeyFactory;
import cz.d1x.dxcrypto.encryption.crypto.RSAPublicKeyFactory;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyPair;

public abstract class AsymmetricAlgorithmBuilder
implements EncryptionAlgorithmBuilder {
    private CryptoKeyFactory publicKeyFactory;
    private CryptoKeyFactory privateKeyFactory;
    private BytesRepresentation bytesRepresentation = new HexRepresentation();
    private String encoding = "UTF-8";

    protected abstract String getAlgorithm();

    protected AsymmetricAlgorithmBuilder() {
    }

    public AsymmetricAlgorithmBuilder publicKey(BigInteger modulus, BigInteger exponent) {
        if (modulus == null || exponent == null) {
            throw new EncryptionException("You must provide both modulus and exponent for public key");
        }
        this.publicKeyFactory = new RSAPublicKeyFactory(modulus, exponent);
        return this;
    }

    public AsymmetricAlgorithmBuilder publicKey(CryptoKeyFactory publicKeyFactory) {
        this.publicKeyFactory = publicKeyFactory;
        return this;
    }

    public AsymmetricAlgorithmBuilder privateKey(BigInteger modulus, BigInteger exponent) {
        if (modulus == null || exponent == null) {
            throw new EncryptionException("You must provide both modulus and exponent for private key");
        }
        this.privateKeyFactory = new RSAPrivateKeyFactory(modulus, exponent);
        return this;
    }

    public AsymmetricAlgorithmBuilder privateKey(CryptoKeyFactory privateKeyFactory) {
        this.privateKeyFactory = privateKeyFactory;
        return this;
    }

    public AsymmetricAlgorithmBuilder keyPair(final KeyPair keyPair) {
        if (keyPair == null) {
            throw new EncryptionException("You must provide non-null key pair");
        }
        this.publicKeyFactory = new CryptoKeyFactory(){

            @Override
            public Key getKey() throws EncryptionException {
                return keyPair.getPublic();
            }
        };
        this.privateKeyFactory = new CryptoKeyFactory(){

            @Override
            public Key getKey() throws EncryptionException {
                return keyPair.getPrivate();
            }
        };
        return this;
    }

    public AsymmetricAlgorithmBuilder bytesRepresentation(BytesRepresentation bytesRepresentation) {
        this.bytesRepresentation = bytesRepresentation;
        return this;
    }

    public AsymmetricAlgorithmBuilder encoding(String encoding) {
        this.encoding = encoding;
        return this;
    }

    @Override
    public EncryptionAlgorithm build() throws EncryptionException {
        return new AsymmetricAlgorithm(this.getAlgorithm(), this.publicKeyFactory, this.privateKeyFactory, this.bytesRepresentation, this.encoding);
    }
}

