/*
 * Decompiled with CFR 0.152.
 */
package cz.d1x.dxcrypto.hash;

import cz.d1x.dxcrypto.common.BytesRepresentation;
import cz.d1x.dxcrypto.common.CombineAlgorithm;
import cz.d1x.dxcrypto.hash.HashingAlgorithm;
import cz.d1x.dxcrypto.hash.HashingAlgorithmBuilder;
import cz.d1x.dxcrypto.hash.RepeatingDecorator;
import cz.d1x.dxcrypto.hash.SaltingAdapterBuilder;

public class RepeatingDecoratorBuilder
implements HashingAlgorithmBuilder {
    private final HashingAlgorithm hashingAlgorithm;
    private final BytesRepresentation bytesRepresentation;
    private final String encoding;
    private int repeats = -1;

    public RepeatingDecoratorBuilder(HashingAlgorithm hashingAlgorithm, BytesRepresentation bytesRepresentation, String encoding) {
        this.hashingAlgorithm = hashingAlgorithm;
        this.bytesRepresentation = bytesRepresentation;
        this.encoding = encoding;
    }

    public RepeatingDecoratorBuilder repeats(int repeats) {
        if (repeats < 1) {
            throw new IllegalArgumentException("Expecting at least 1 repeat");
        }
        this.repeats = repeats;
        return this;
    }

    public SaltingAdapterBuilder salted() {
        RepeatingDecorator repeatingDecorator = this.build();
        return new SaltingAdapterBuilder(repeatingDecorator, this.bytesRepresentation, this.encoding);
    }

    public SaltingAdapterBuilder salted(CombineAlgorithm combineAlgorithm) {
        RepeatingDecorator repeatingDecorator = this.build();
        return new SaltingAdapterBuilder(repeatingDecorator, this.bytesRepresentation, this.encoding).combineAlgorithm(combineAlgorithm);
    }

    @Override
    public RepeatingDecorator build() {
        return new RepeatingDecorator(this.hashingAlgorithm, this.repeats);
    }
}

