/*
 * Decompiled with CFR 0.152.
 */
package cz.d1x.dxcrypto.hash;

import cz.d1x.dxcrypto.common.BytesRepresentation;
import cz.d1x.dxcrypto.common.CombineAlgorithm;
import cz.d1x.dxcrypto.common.Encoding;
import cz.d1x.dxcrypto.hash.HashingAlgorithm;
import cz.d1x.dxcrypto.hash.HashingException;

public class SaltingAdapter {
    private final HashingAlgorithm hashingAlgorithm;
    private final CombineAlgorithm combineAlgorithm;
    private final BytesRepresentation bytesRepresentation;
    private final String encoding;

    protected SaltingAdapter(HashingAlgorithm hashingAlgorithm, BytesRepresentation bytesRepresentation, CombineAlgorithm combineAlgorithm, String encoding) {
        if (hashingAlgorithm == null) {
            throw new IllegalArgumentException("Expecting non-null adapted algorithm");
        }
        this.hashingAlgorithm = hashingAlgorithm;
        if (combineAlgorithm == null) {
            throw new IllegalArgumentException("Expecting non-null combine strategy");
        }
        this.combineAlgorithm = combineAlgorithm;
        this.bytesRepresentation = bytesRepresentation;
        Encoding.checkEncoding(encoding);
        this.encoding = encoding;
    }

    public String hash(String input, String salt) throws HashingException {
        byte[] inputBytes = Encoding.getBytes(input, this.encoding);
        byte[] saltBytes = Encoding.getBytes(salt, this.encoding);
        byte[] hashed = this.hash(inputBytes, saltBytes);
        return this.bytesRepresentation.toString(hashed);
    }

    public byte[] hash(byte[] input, byte[] salt) throws HashingException {
        byte[] toHash = this.combineAlgorithm.combine(input, salt);
        return this.hashingAlgorithm.hash(toHash);
    }
}

