/*
 * Decompiled with CFR 0.152.
 */
package cz.d1x.dxcrypto.hash.digest;

import cz.d1x.dxcrypto.common.BytesRepresentation;
import cz.d1x.dxcrypto.common.CombineAlgorithm;
import cz.d1x.dxcrypto.common.HexRepresentation;
import cz.d1x.dxcrypto.encryption.EncryptionException;
import cz.d1x.dxcrypto.hash.HashingAlgorithm;
import cz.d1x.dxcrypto.hash.HashingAlgorithmBuilder;
import cz.d1x.dxcrypto.hash.RepeatingDecoratorBuilder;
import cz.d1x.dxcrypto.hash.SaltingAdapterBuilder;
import cz.d1x.dxcrypto.hash.digest.DigestAlgorithm;

public abstract class DigestAlgorithmBuilder
implements HashingAlgorithmBuilder {
    private BytesRepresentation bytesRepresentation = new HexRepresentation();
    private String encoding = "UTF-8";

    protected DigestAlgorithmBuilder() {
    }

    protected abstract String getAlgorithm();

    public DigestAlgorithmBuilder bytesRepresentation(BytesRepresentation bytesRepresentation) {
        this.bytesRepresentation = bytesRepresentation;
        return this;
    }

    public DigestAlgorithmBuilder encoding(String encoding) {
        this.encoding = encoding;
        return this;
    }

    public SaltingAdapterBuilder salted() {
        HashingAlgorithm alg = this.build();
        return new SaltingAdapterBuilder(alg, this.bytesRepresentation, this.encoding);
    }

    public SaltingAdapterBuilder salted(CombineAlgorithm combineAlgorithm) {
        HashingAlgorithm alg = this.build();
        return new SaltingAdapterBuilder(alg, this.bytesRepresentation, this.encoding);
    }

    public RepeatingDecoratorBuilder repeated(int repeats) {
        HashingAlgorithm alg = this.build();
        return new RepeatingDecoratorBuilder(alg, this.bytesRepresentation, this.encoding).repeats(repeats);
    }

    @Override
    public HashingAlgorithm build() throws EncryptionException {
        return new DigestAlgorithm(this.getAlgorithm(), this.bytesRepresentation, this.encoding);
    }
}

