/*
 * Decompiled with CFR 0.152.
 */
package cz.d1x.dxcrypto.common;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;

public class Encoding {
    public static final String DEFAULT = "UTF-8";

    public static void checkEncoding(String encoding) throws IllegalArgumentException {
        boolean isSupported;
        try {
            isSupported = Charset.isSupported(encoding);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Given encoding " + encoding + " is not supported");
        }
        if (!isSupported) {
            throw new IllegalArgumentException("Given encoding " + encoding + " is not supported");
        }
    }

    public static byte[] getBytes(String text, String encoding) throws IllegalArgumentException {
        if (text == null) {
            throw new IllegalArgumentException("Given text cannot be null");
        }
        try {
            return text.getBytes(encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("Given encoding " + encoding + " is not supported");
        }
    }

    public static byte[] getBytes(String text) {
        return Encoding.getBytes(text, DEFAULT);
    }

    public static String getString(byte[] text, String encoding) throws IllegalArgumentException {
        if (text == null) {
            throw new IllegalArgumentException("Given text bytes cannot be null");
        }
        try {
            return new String(text, encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("Given encoding " + encoding + " is not supported");
        }
    }

    public static String getString(byte[] text) {
        return Encoding.getString(text, DEFAULT);
    }
}

