/*
 * Decompiled with CFR 0.152.
 */
package cz.d1x.dxcrypto.common;

import cz.d1x.dxcrypto.common.BytesRepresentation;
import javax.xml.bind.DatatypeConverter;

public class HexRepresentation
implements BytesRepresentation {
    private static final boolean DEFAULT_USE_LOWER_CASE = true;
    private final boolean useLowerCase;

    public HexRepresentation() {
        this(true);
    }

    public HexRepresentation(boolean useLowerCase) {
        this.useLowerCase = useLowerCase;
    }

    @Override
    public String toString(byte[] bytes) throws IllegalArgumentException {
        if (bytes == null) {
            throw new IllegalArgumentException("Input bytes cannot be null when converted to HEX");
        }
        try {
            return this.doCasing(DatatypeConverter.printHexBinary((byte[])bytes));
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Input bytes cannot be converted to HEX", e);
        }
    }

    @Override
    public byte[] toBytes(String hex) throws IllegalArgumentException {
        if (hex == null) {
            throw new IllegalArgumentException("Input HEX cannot be null when converted to bytes");
        }
        try {
            return DatatypeConverter.parseHexBinary((String)this.doCasing(hex));
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Input HEX cannot be converted to bytes", e);
        }
    }

    private String doCasing(String result) {
        return this.useLowerCase ? result.toLowerCase() : result.toUpperCase();
    }
}

