/*
 * Decompiled with CFR 0.152.
 */
package cz.d1x.dxcrypto.encryption.crypto;

import cz.d1x.dxcrypto.common.BytesRepresentation;
import cz.d1x.dxcrypto.common.CombineAlgorithm;
import cz.d1x.dxcrypto.common.Encoding;
import cz.d1x.dxcrypto.encryption.EncryptionAlgorithm;
import cz.d1x.dxcrypto.encryption.EncryptionException;
import cz.d1x.dxcrypto.encryption.crypto.CryptoKeyFactory;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;

public final class SymmetricAlgorithm
implements EncryptionAlgorithm {
    private final SecureRandom random = new SecureRandom();
    private final Cipher cipher;
    private final int blockSize;
    private final Key key;
    private final CombineAlgorithm combineAlgorithm;
    private final BytesRepresentation bytesRepresentation;
    private final String encoding;

    protected SymmetricAlgorithm(String cipherName, CryptoKeyFactory keyFactory, CombineAlgorithm combineAlgorithm, BytesRepresentation bytesRepresentation, String encoding) throws EncryptionException {
        Encoding.checkEncoding(encoding);
        this.combineAlgorithm = combineAlgorithm;
        this.bytesRepresentation = bytesRepresentation;
        this.encoding = encoding;
        try {
            this.cipher = Cipher.getInstance(cipherName);
            this.blockSize = this.cipher.getBlockSize();
            this.key = (Key)keyFactory.getKey();
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new EncryptionException("Invalid encryption algorithm", e);
        }
    }

    @Override
    public byte[] encrypt(byte[] input) throws EncryptionException {
        try {
            IvParameterSpec iv = this.generateIV();
            this.initCipher(iv, true);
            byte[] encryptedBytes = this.cipher.doFinal(input);
            return this.combineAlgorithm.combine(iv.getIV(), encryptedBytes);
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            throw new EncryptionException("Unable to encrypt input", e);
        }
    }

    @Override
    public String encrypt(String input) throws EncryptionException {
        byte[] textBytes = Encoding.getBytes(input, this.encoding);
        byte[] encryptedBytes = this.encrypt(textBytes);
        return this.bytesRepresentation.toString(encryptedBytes);
    }

    @Override
    public byte[] decrypt(byte[] input) throws EncryptionException {
        try {
            byte[][] ivAndCipherText = this.combineAlgorithm.split(input);
            IvParameterSpec iv = new IvParameterSpec(ivAndCipherText[0]);
            this.initCipher(iv, false);
            return this.cipher.doFinal(ivAndCipherText[1]);
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            throw new EncryptionException("Unable to decrypt input", e);
        }
    }

    @Override
    public String decrypt(String input) throws EncryptionException {
        byte[] textBytes = this.bytesRepresentation.toBytes(input);
        byte[] decryptedBytes = this.decrypt(textBytes);
        return Encoding.getString(decryptedBytes, this.encoding);
    }

    private IvParameterSpec generateIV() {
        byte[] iv = new byte[this.blockSize];
        this.random.nextBytes(iv);
        return new IvParameterSpec(iv);
    }

    private void initCipher(IvParameterSpec iv, boolean isEncrypt) throws EncryptionException {
        try {
            this.cipher.init(isEncrypt ? 1 : 2, this.key, iv);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException e) {
            throw new EncryptionException("Unable to initialize cipher", e);
        }
    }
}

