/*
 * Decompiled with CFR 0.152.
 */
package cz.d1x.dxcrypto.hash.digest;

import cz.d1x.dxcrypto.common.BytesRepresentation;
import cz.d1x.dxcrypto.common.Encoding;
import cz.d1x.dxcrypto.hash.HashingAlgorithm;
import cz.d1x.dxcrypto.hash.HashingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public final class DigestAlgorithm
implements HashingAlgorithm {
    private final MessageDigest digest;
    private final BytesRepresentation bytesRepresentation;
    private final String encoding;

    protected DigestAlgorithm(String digestName, BytesRepresentation bytesRepresentation, String encoding) {
        Encoding.checkEncoding(encoding);
        this.bytesRepresentation = bytesRepresentation;
        this.encoding = encoding;
        try {
            this.digest = MessageDigest.getInstance(digestName);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new HashingException(ex);
        }
    }

    @Override
    public byte[] hash(byte[] input) throws HashingException {
        if (input == null) {
            throw new HashingException("Input data for hashing cannot be null");
        }
        this.digest.reset();
        return this.digest.digest(input);
    }

    @Override
    public String hash(String input) throws HashingException {
        if (input == null) {
            throw new HashingException("Input data for hashing cannot be null");
        }
        byte[] textBytes = Encoding.getBytes(input, this.encoding);
        byte[] hash = this.hash(textBytes);
        return this.bytesRepresentation.toString(hash);
    }
}

