/*
 * Decompiled with CFR 0.152.
 */
package cz.d1x.dxcrypto.common;

import cz.d1x.dxcrypto.common.CombineSplitAlgorithm;
import cz.d1x.dxcrypto.encryption.EncryptionException;

public class ConcatAlgorithm
implements CombineSplitAlgorithm {
    private static final int INPUT_LENGTH_NOT_SET = -1;
    private final int input1Length;

    public ConcatAlgorithm() {
        this.input1Length = -1;
    }

    public ConcatAlgorithm(int input1Length) {
        if (input1Length < 0) {
            throw new IllegalArgumentException("Input length must be greater than 0");
        }
        this.input1Length = input1Length;
    }

    @Override
    public byte[] combine(byte[] input1, byte[] input2) {
        if (this.input1Length != -1 && this.input1Length != input1.length) {
            throw new IllegalArgumentException("Length of first input must be " + this.input1Length);
        }
        byte[] out = new byte[input1.length + input2.length];
        System.arraycopy(input1, 0, out, 0, input1.length);
        System.arraycopy(input2, 0, out, input1.length, input2.length);
        return out;
    }

    @Override
    public byte[][] split(byte[] combined) {
        if (this.input1Length == -1) {
            throw new EncryptionException("Input length was not specified (wrong constructor), unable to split input");
        }
        if (combined.length <= this.input1Length) {
            throw new EncryptionException("Given input is too short, probably it was not combined by this instance");
        }
        byte[] input1 = new byte[this.input1Length];
        byte[] input2 = new byte[combined.length - input1.length];
        System.arraycopy(combined, 0, input1, 0, input1.length);
        System.arraycopy(combined, input1.length, input2, 0, input2.length);
        byte[][] out = new byte[][]{input1, input2};
        return out;
    }
}

