/*
 * Decompiled with CFR 0.152.
 */
package cz.d1x.dxcrypto.encryption;

import cz.d1x.dxcrypto.common.Encoding;
import cz.d1x.dxcrypto.encryption.AsymmetricCryptoAlgorithmBuilder;
import cz.d1x.dxcrypto.encryption.KeyFactory;
import cz.d1x.dxcrypto.encryption.SymmetricCryptoAlgorithmBuilder;
import java.security.Key;

public class EncryptionAlgorithms {
    public static SymmetricCryptoAlgorithmBuilder aes(byte[] keyPassword) throws IllegalArgumentException {
        return new SymmetricCryptoAlgorithmBuilder(keyPassword, "AES/CBC/PKCS5Padding", "AES", 128, 16);
    }

    public static SymmetricCryptoAlgorithmBuilder aes(String keyPassword) throws IllegalArgumentException {
        return EncryptionAlgorithms.aes(Encoding.getBytes(keyPassword));
    }

    public static SymmetricCryptoAlgorithmBuilder aes(KeyFactory<Key> keyFactory) throws IllegalArgumentException {
        return new SymmetricCryptoAlgorithmBuilder(keyFactory, "AES/CBC/PKCS5Padding", "AES", 16);
    }

    public static SymmetricCryptoAlgorithmBuilder tripleDes(byte[] keyPassword) throws IllegalArgumentException {
        int keySize = 192;
        return new SymmetricCryptoAlgorithmBuilder(keyPassword, "DESede/CBC/PKCS5Padding", "DESede", keySize, 8);
    }

    public static SymmetricCryptoAlgorithmBuilder tripleDes(String keyPassword) throws IllegalArgumentException {
        return EncryptionAlgorithms.tripleDes(Encoding.getBytes(keyPassword));
    }

    public static SymmetricCryptoAlgorithmBuilder tripleDes(KeyFactory<Key> keyFactory) throws IllegalArgumentException {
        return new SymmetricCryptoAlgorithmBuilder(keyFactory, "DESede/CBC/PKCS5Padding", "DESede", 8);
    }

    public static AsymmetricCryptoAlgorithmBuilder rsa() {
        return new AsymmetricCryptoAlgorithmBuilder("RSA/ECB/OAEPWithSHA-256AndMGF1Padding");
    }
}

