/*
 * Decompiled with CFR 0.152.
 */
package cz.d1x.dxcrypto.hash;

import cz.d1x.dxcrypto.common.BytesRepresentation;
import cz.d1x.dxcrypto.common.CombineAlgorithm;
import cz.d1x.dxcrypto.hash.HashingAlgorithm;
import cz.d1x.dxcrypto.hash.RepeatingDecorator;
import cz.d1x.dxcrypto.hash.SaltingAdapterBuilder;

public final class RepeatingDecoratorBuilder {
    private final HashingAlgorithm hashingAlgorithm;
    private final BytesRepresentation bytesRepresentation;
    private final String encoding;
    private int repeats = -1;

    public RepeatingDecoratorBuilder(HashingAlgorithm hashingAlgorithm, BytesRepresentation bytesRepresentation, String encoding) {
        this.hashingAlgorithm = hashingAlgorithm;
        this.bytesRepresentation = bytesRepresentation;
        this.encoding = encoding;
    }

    public RepeatingDecoratorBuilder repeats(int repeats) {
        if (repeats < 1) {
            throw new IllegalArgumentException("You must provide repeats >= 1!");
        }
        this.repeats = repeats;
        return this;
    }

    public SaltingAdapterBuilder salted() {
        RepeatingDecorator repeatingDecorator = this.build();
        return new SaltingAdapterBuilder(repeatingDecorator, this.bytesRepresentation, this.encoding);
    }

    public SaltingAdapterBuilder salted(CombineAlgorithm combineAlgorithm) {
        if (combineAlgorithm == null) {
            throw new IllegalArgumentException("You must provide non-null CombineAlgorithm!");
        }
        RepeatingDecorator repeatingDecorator = this.build();
        return new SaltingAdapterBuilder(repeatingDecorator, this.bytesRepresentation, this.encoding).combineAlgorithm(combineAlgorithm);
    }

    public RepeatingDecorator build() {
        return new RepeatingDecorator(this.hashingAlgorithm, this.repeats);
    }
}

