/*
 * Decompiled with CFR 0.152.
 */
package cz.d1x.dxcrypto.encryption;

import cz.d1x.dxcrypto.common.BytesRepresentation;
import cz.d1x.dxcrypto.common.CombineSplitAlgorithm;
import cz.d1x.dxcrypto.common.ConcatAlgorithm;
import cz.d1x.dxcrypto.common.Encoding;
import cz.d1x.dxcrypto.common.HexRepresentation;
import cz.d1x.dxcrypto.encryption.EncryptionAlgorithm;
import cz.d1x.dxcrypto.encryption.KeyFactory;
import cz.d1x.dxcrypto.encryption.PBKDF2KeyFactory;
import cz.d1x.dxcrypto.encryption.SymmetricCryptoAlgorithm;
import java.security.Key;

public final class SymmetricCryptoAlgorithmBuilder {
    private static final byte[] DEFAULT_KEY_SALT = new byte[]{39, 17, 101, 53, 19, 119, 51, 33, 64, 67, 24, 101};
    private static final int DEFAULT_KEY_HASH_ITERATIONS = 4096;
    private final String algorithmName;
    private final String shortAlgorithmName;
    private final int keySize;
    private final KeyFactory<Key> keyFactory;
    private final byte[] keyPassword;
    private byte[] keySalt = DEFAULT_KEY_SALT;
    private int keyHashIterations = 4096;
    private BytesRepresentation bytesRepresentation = new HexRepresentation();
    private String encoding = "UTF-8";
    private CombineSplitAlgorithm combineSplitAlgorithm;

    public SymmetricCryptoAlgorithmBuilder(byte[] keyPassword, String algorithmName, String shortAlgorithmName, int keySize, int blockSize) {
        if (keyPassword == null) {
            throw new IllegalArgumentException("You must provide non-null key password!");
        }
        this.keyPassword = keyPassword;
        this.keySize = keySize;
        this.keyFactory = null;
        this.algorithmName = algorithmName;
        this.shortAlgorithmName = shortAlgorithmName;
        this.combineSplitAlgorithm = new ConcatAlgorithm(blockSize / 8);
    }

    public SymmetricCryptoAlgorithmBuilder(KeyFactory<Key> keyFactory, String algorithmName, String shortAlgorithmName, int blockSize) {
        if (keyFactory == null) {
            throw new IllegalArgumentException("You must provide non-null key factory!");
        }
        this.keyPassword = null;
        this.keySize = -1;
        this.keyFactory = keyFactory;
        this.algorithmName = algorithmName;
        this.shortAlgorithmName = shortAlgorithmName;
        this.combineSplitAlgorithm = new ConcatAlgorithm(blockSize);
    }

    public SymmetricCryptoAlgorithmBuilder keySalt(byte[] keySalt) throws IllegalArgumentException {
        if (keySalt == null) {
            throw new IllegalArgumentException("You must provide non-null key salt!");
        }
        this.keySalt = keySalt;
        return this;
    }

    public SymmetricCryptoAlgorithmBuilder keySalt(String keySalt) throws IllegalArgumentException {
        this.checkKeyFactory();
        if (keySalt == null) {
            throw new IllegalArgumentException("You must provide non-null key salt!");
        }
        return this.keySalt(Encoding.getBytes(keySalt));
    }

    public SymmetricCryptoAlgorithmBuilder keyHashIterations(int keyHashIterations) throws IllegalArgumentException {
        this.checkKeyFactory();
        if (keyHashIterations < 1) {
            throw new IllegalArgumentException("You must provide iterations for key hashing >= 1!");
        }
        this.keyHashIterations = keyHashIterations;
        return this;
    }

    public SymmetricCryptoAlgorithmBuilder combineSplitAlgorithm(CombineSplitAlgorithm combineSplitAlgorithm) throws IllegalArgumentException {
        if (combineSplitAlgorithm == null) {
            throw new IllegalArgumentException("You must provide non-null CombineSplitAlgorithm!");
        }
        this.combineSplitAlgorithm = combineSplitAlgorithm;
        return this;
    }

    public SymmetricCryptoAlgorithmBuilder bytesRepresentation(BytesRepresentation bytesRepresentation) throws IllegalArgumentException {
        if (bytesRepresentation == null) {
            throw new IllegalArgumentException("You must provide non-null BytesRepresentation!");
        }
        this.bytesRepresentation = bytesRepresentation;
        return this;
    }

    public SymmetricCryptoAlgorithmBuilder encoding(String encoding) throws IllegalArgumentException {
        if (encoding == null) {
            throw new IllegalArgumentException("You must provide non-null encoding!");
        }
        Encoding.checkEncoding(encoding);
        this.encoding = encoding;
        return this;
    }

    private void checkKeyFactory() throws IllegalArgumentException {
        if (this.keyFactory != null) {
            throw new IllegalArgumentException("You initialized builder with custom key factory. It is not allowed to use key salt or hash iterations (it wouldn't be used anyway)");
        }
    }

    public EncryptionAlgorithm build() throws IllegalArgumentException {
        PBKDF2KeyFactory kf = this.keyFactory != null ? this.keyFactory : new PBKDF2KeyFactory(this.shortAlgorithmName, this.keyPassword, this.keySize, this.keySalt, this.keyHashIterations);
        return new SymmetricCryptoAlgorithm(this.algorithmName, kf, this.combineSplitAlgorithm, this.bytesRepresentation, this.encoding);
    }
}

