/*
 * Decompiled with CFR 0.152.
 */
package cz.d1x.dxcrypto.encryption;

import cz.d1x.dxcrypto.encryption.EncryptionException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;

public final class RSAKeysGenerator {
    private static final int DEFAULT_KEY_SIZE = 1024;
    private final KeyPairGenerator generator;

    public RSAKeysGenerator() {
        this(1024);
    }

    public RSAKeysGenerator(int keySize) throws EncryptionException {
        try {
            this.generator = KeyPairGenerator.getInstance("RSA");
            this.generator.initialize(keySize);
        }
        catch (NoSuchAlgorithmException e) {
            throw new EncryptionException("Unable to initialize RSA keys generator, is it supported by your JRE?", e);
        }
    }

    public KeyPair generateKeys() {
        return this.generator.generateKeyPair();
    }
}

