/*
 * Decompiled with CFR 0.152.
 */
package cz.d1x.dxcrypto.hash;

import cz.d1x.dxcrypto.common.BytesRepresentation;
import cz.d1x.dxcrypto.common.CombineAlgorithm;
import cz.d1x.dxcrypto.common.ConcatAlgorithm;
import cz.d1x.dxcrypto.hash.HashingAlgorithm;
import cz.d1x.dxcrypto.hash.SaltedHashingAlgorithm;
import cz.d1x.dxcrypto.hash.SaltingAdapter;

public final class SaltingAdapterBuilder {
    private final HashingAlgorithm hashingAlgorithm;
    private final BytesRepresentation bytesRepresentation;
    private final String encoding;
    private CombineAlgorithm combineAlgorithm = new ConcatAlgorithm();

    public SaltingAdapterBuilder(HashingAlgorithm hashingAlgorithm, BytesRepresentation bytesRepresentation, String encoding) {
        this.hashingAlgorithm = hashingAlgorithm;
        this.bytesRepresentation = bytesRepresentation;
        this.encoding = encoding;
    }

    public SaltingAdapterBuilder combineAlgorithm(CombineAlgorithm combineAlgorithm) {
        if (combineAlgorithm == null) {
            throw new IllegalArgumentException("You must provide non-null CombineAlgorithm!");
        }
        this.combineAlgorithm = combineAlgorithm;
        return this;
    }

    public SaltedHashingAlgorithm build() {
        return new SaltingAdapter(this.hashingAlgorithm, this.bytesRepresentation, this.combineAlgorithm, this.encoding);
    }
}

