/*
 * Decompiled with CFR 0.152.
 */
package cz.d1x.dxcrypto.encryption;

import cz.d1x.dxcrypto.common.BytesRepresentation;
import cz.d1x.dxcrypto.common.Encoding;
import cz.d1x.dxcrypto.common.HexRepresentation;
import cz.d1x.dxcrypto.encryption.AsymmetricCryptoAlgorithm;
import cz.d1x.dxcrypto.encryption.EncryptionAlgorithm;
import cz.d1x.dxcrypto.encryption.EncryptionException;
import cz.d1x.dxcrypto.encryption.KeyFactory;
import cz.d1x.dxcrypto.encryption.RSAPrivateKeyFactory;
import cz.d1x.dxcrypto.encryption.RSAPublicKeyFactory;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyPair;

public final class AsymmetricCryptoAlgorithmBuilder {
    private final String algorithmName;
    private KeyFactory<Key> publicKeyFactory;
    private KeyFactory<Key> privateKeyFactory;
    private BytesRepresentation bytesRepresentation = new HexRepresentation();
    private String encoding = "UTF-8";

    public AsymmetricCryptoAlgorithmBuilder(String algorithmName) {
        this.algorithmName = algorithmName;
    }

    public AsymmetricCryptoAlgorithmBuilder publicKey(BigInteger modulus, BigInteger exponent) {
        if (modulus == null || exponent == null) {
            throw new EncryptionException("You must provide non-null both modulus and exponent for public key!");
        }
        this.publicKeyFactory = new RSAPublicKeyFactory(modulus, exponent);
        return this;
    }

    public AsymmetricCryptoAlgorithmBuilder publicKey(KeyFactory<Key> publicKeyFactory) {
        if (publicKeyFactory == null) {
            throw new EncryptionException("You must provide non-null key factory!");
        }
        this.publicKeyFactory = publicKeyFactory;
        return this;
    }

    public AsymmetricCryptoAlgorithmBuilder privateKey(BigInteger modulus, BigInteger exponent) {
        if (modulus == null || exponent == null) {
            throw new IllegalArgumentException("You must provide non-null both modulus and exponent for private key");
        }
        this.privateKeyFactory = new RSAPrivateKeyFactory(modulus, exponent);
        return this;
    }

    public AsymmetricCryptoAlgorithmBuilder privateKey(KeyFactory<Key> privateKeyFactory) {
        if (privateKeyFactory == null) {
            throw new IllegalArgumentException("You must provide non-null private key factory!");
        }
        this.privateKeyFactory = privateKeyFactory;
        return this;
    }

    public AsymmetricCryptoAlgorithmBuilder keyPair(final KeyPair keyPair) {
        if (keyPair == null) {
            throw new IllegalArgumentException("You must provide non-null key pair");
        }
        this.publicKeyFactory = new KeyFactory<Key>(){

            @Override
            public Key getKey() throws EncryptionException {
                return keyPair.getPublic();
            }
        };
        this.privateKeyFactory = new KeyFactory<Key>(){

            @Override
            public Key getKey() throws EncryptionException {
                return keyPair.getPrivate();
            }
        };
        return this;
    }

    public AsymmetricCryptoAlgorithmBuilder bytesRepresentation(BytesRepresentation bytesRepresentation) {
        if (bytesRepresentation == null) {
            throw new IllegalArgumentException("You must provide non-null BytesRepresentation!");
        }
        this.bytesRepresentation = bytesRepresentation;
        return this;
    }

    public AsymmetricCryptoAlgorithmBuilder encoding(String encoding) {
        if (encoding == null) {
            throw new IllegalArgumentException("You must provide non-null encoding!");
        }
        Encoding.checkEncoding(encoding);
        this.encoding = encoding;
        return this;
    }

    public EncryptionAlgorithm build() throws IllegalArgumentException {
        if (this.publicKeyFactory == null && this.privateKeyFactory == null) {
            throw new IllegalArgumentException("At least one (public or private) key must be set");
        }
        return new AsymmetricCryptoAlgorithm(this.algorithmName, this.publicKeyFactory, this.privateKeyFactory, this.bytesRepresentation, this.encoding);
    }
}

