/*
 * Decompiled with CFR 0.152.
 */
package cz.d1x.dxcrypto.encryption;

import cz.d1x.dxcrypto.common.Encoding;
import cz.d1x.dxcrypto.encryption.AsymmetricCryptoAlgorithmBuilder;
import cz.d1x.dxcrypto.encryption.KeyFactory;
import cz.d1x.dxcrypto.encryption.SymmetricCryptoAlgorithmBuilder;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;

public class EncryptionAlgorithms {
    public static SymmetricCryptoAlgorithmBuilder aes(byte[] keyPassword) throws IllegalArgumentException {
        return new SymmetricCryptoAlgorithmBuilder(keyPassword, "AES/CBC/PKCS5Padding", "AES", 128, 128);
    }

    public static SymmetricCryptoAlgorithmBuilder aes(String keyPassword) throws IllegalArgumentException {
        return EncryptionAlgorithms.aes(Encoding.getBytes(keyPassword));
    }

    public static SymmetricCryptoAlgorithmBuilder aes(KeyFactory<Key> keyFactory) throws IllegalArgumentException {
        return new SymmetricCryptoAlgorithmBuilder(keyFactory, "AES/CBC/PKCS5Padding", "AES", 128);
    }

    public static SymmetricCryptoAlgorithmBuilder aes256(byte[] keyPassword) throws IllegalArgumentException {
        EncryptionAlgorithms.checkCipherSupported("AES", 256);
        return new SymmetricCryptoAlgorithmBuilder(keyPassword, "AES/CBC/PKCS5Padding", "AES", 256, 128);
    }

    public static SymmetricCryptoAlgorithmBuilder aes256(String keyPassword) throws IllegalArgumentException {
        EncryptionAlgorithms.checkCipherSupported("AES", 256);
        return EncryptionAlgorithms.aes256(Encoding.getBytes(keyPassword));
    }

    public static SymmetricCryptoAlgorithmBuilder tripleDes(byte[] keyPassword) throws IllegalArgumentException {
        int keySize = 192;
        return new SymmetricCryptoAlgorithmBuilder(keyPassword, "DESede/CBC/PKCS5Padding", "DESede", keySize, 64);
    }

    public static SymmetricCryptoAlgorithmBuilder tripleDes(String keyPassword) throws IllegalArgumentException {
        return EncryptionAlgorithms.tripleDes(Encoding.getBytes(keyPassword));
    }

    public static SymmetricCryptoAlgorithmBuilder tripleDes(KeyFactory<Key> keyFactory) throws IllegalArgumentException {
        return new SymmetricCryptoAlgorithmBuilder(keyFactory, "DESede/CBC/PKCS5Padding", "DESede", 64);
    }

    public static AsymmetricCryptoAlgorithmBuilder rsa() {
        return new AsymmetricCryptoAlgorithmBuilder("RSA/ECB/OAEPWithSHA-256AndMGF1Padding");
    }

    public static boolean isJceInstalled() {
        try {
            return Cipher.getMaxAllowedKeyLength("AES") == Integer.MAX_VALUE;
        }
        catch (NoSuchAlgorithmException e) {
            return false;
        }
    }

    private static void checkCipherSupported(String name, int keySize) {
        if (!EncryptionAlgorithms.isJceInstalled()) {
            throw new IllegalArgumentException("Cipher " + name + " is not supported with key size of " + keySize + "b,  probably Java Cryptography Extension (JCE) is not installed in your Java.");
        }
    }
}

