/*
 * Decompiled with CFR 0.152.
 */
package cz.d1x.dxcrypto.encryption;

import cz.d1x.dxcrypto.common.BytesRepresentation;
import cz.d1x.dxcrypto.common.CombineSplitAlgorithm;
import cz.d1x.dxcrypto.common.Encoding;
import cz.d1x.dxcrypto.encryption.EncryptionAlgorithm;
import cz.d1x.dxcrypto.encryption.EncryptionException;
import cz.d1x.dxcrypto.encryption.KeyFactory;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;

public final class SymmetricCryptoAlgorithm
implements EncryptionAlgorithm {
    private final SecureRandom random = new SecureRandom();
    private final String cipherName;
    private final int blockSize;
    private final Key key;
    private final CombineSplitAlgorithm combineSplitAlgorithm;
    private final BytesRepresentation bytesRepresentation;
    private final String encoding;

    protected SymmetricCryptoAlgorithm(String cipherName, KeyFactory<Key> keyFactory, CombineSplitAlgorithm combineSplitAlgorithm, BytesRepresentation bytesRepresentation, String encoding) throws EncryptionException {
        this.combineSplitAlgorithm = combineSplitAlgorithm;
        this.bytesRepresentation = bytesRepresentation;
        this.encoding = encoding;
        try {
            Cipher cipher = Cipher.getInstance(cipherName);
            this.blockSize = cipher.getBlockSize();
            this.cipherName = cipherName;
            this.key = keyFactory.getKey();
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new EncryptionException("Invalid encryption algorithm", e);
        }
    }

    @Override
    public byte[] encrypt(byte[] input) throws EncryptionException {
        if (input == null) {
            throw new IllegalArgumentException("Input data for encryption cannot be null!");
        }
        try {
            IvParameterSpec iv = this.generateIV();
            Cipher cipher = this.createCipher(iv, true);
            byte[] encryptedBytes = cipher.doFinal(input);
            return this.combineSplitAlgorithm.combine(iv.getIV(), encryptedBytes);
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            throw new EncryptionException("Unable to encrypt input", e);
        }
    }

    @Override
    public String encrypt(String input) throws EncryptionException {
        if (input == null) {
            throw new IllegalArgumentException("Input data for encryption cannot be null!");
        }
        byte[] textBytes = Encoding.getBytes(input, this.encoding);
        byte[] encryptedBytes = this.encrypt(textBytes);
        return this.bytesRepresentation.toString(encryptedBytes);
    }

    @Override
    public byte[] decrypt(byte[] input) throws EncryptionException {
        if (input == null) {
            throw new IllegalArgumentException("Input data for decryption cannot be null!");
        }
        try {
            byte[][] ivAndCipherText = this.combineSplitAlgorithm.split(input);
            if (ivAndCipherText == null || ivAndCipherText.length != 2) {
                throw new EncryptionException("Splitting of input into two parts during decryption produced wrong number of parts. Is the input or used implementation of CombineSplitAlgorithm correct?");
            }
            IvParameterSpec iv = new IvParameterSpec(ivAndCipherText[0]);
            Cipher cipher = this.createCipher(iv, false);
            return cipher.doFinal(ivAndCipherText[1]);
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            throw new EncryptionException("Unable to decrypt input", e);
        }
    }

    @Override
    public String decrypt(String input) throws EncryptionException {
        if (input == null) {
            throw new IllegalArgumentException("Input data for decryption cannot be null!");
        }
        byte[] textBytes = this.bytesRepresentation.toBytes(input);
        byte[] decryptedBytes = this.decrypt(textBytes);
        return Encoding.getString(decryptedBytes, this.encoding);
    }

    private IvParameterSpec generateIV() {
        byte[] iv = new byte[this.blockSize];
        this.random.nextBytes(iv);
        return new IvParameterSpec(iv);
    }

    private Cipher createCipher(IvParameterSpec iv, boolean isEncrypt) throws EncryptionException {
        try {
            Cipher cipher = Cipher.getInstance(this.cipherName);
            cipher.init(isEncrypt ? 1 : 2, this.key, iv);
            return cipher;
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new EncryptionException("Unable to initialize cipher", e);
        }
    }
}

