/*
 * Decompiled with CFR 0.152.
 */
package cz.diribet.aqdef.model;

import cz.diribet.aqdef.KKey;
import cz.diribet.aqdef.model.AqdefObjectModel;
import cz.diribet.aqdef.model.CharacteristicIndex;
import cz.diribet.aqdef.model.GroupIndex;
import cz.diribet.aqdef.model.NodeIndex;
import cz.diribet.aqdef.model.PartIndex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.commons.collections4.CollectionUtils;

public class AqdefHierarchy {
    private static final KKey KEY_PART_NODE = KKey.of("K5111");
    private static final KKey KEY_CHARACTERISTIC_NODE = KKey.of("K5112");
    private static final KKey KEY_GROUP_NODE = KKey.of("K5113");
    private static final KKey KEY_NODE_BINDING = KKey.of("K5103");
    private static final KKey KEY_CHARACTERISTIC_BINDING = KKey.of("K5102");
    private static final KKey KEY_SIMPLE_GROUPING_CHARACTERISTIC_PARENT = KKey.of("K2030");
    private static final KKey KEY_SIMPLE_GROUPING_CHARACTERISTIC_CHILD = KKey.of("K2031");
    private TreeMap<NodeIndex, HierarchyEntry> nodeDefinitions = new TreeMap();
    private TreeMap<NodeIndex, List<HierarchyEntry>> nodeBindings = new TreeMap();
    private boolean containsHierarchyInformation;
    private boolean containsSimpleHierarchyInformation;

    public void putEntry(KKey kKey, Integer index, Object value) {
        Objects.requireNonNull(kKey);
        if (kKey.isSimpleHierarchyLevel()) {
            this.putSimpleHierarchyEntry(kKey, index, value);
            return;
        }
        NodeIndex nodeIndex = NodeIndex.of(index);
        if (!this.isNodeDefinition(kKey) && !this.isBinding(kKey)) {
            throw new IllegalArgumentException("Unknown hierarchy entry. Key: " + kKey + " Value: " + Objects.toString(value));
        }
        HierarchyEntry hierarchyEntry = new HierarchyEntry(kKey, nodeIndex, (Integer)value);
        this.putEntry(hierarchyEntry);
    }

    public void putEntry(HierarchyEntry entry) {
        Objects.requireNonNull(entry);
        KKey kKey = entry.getKey();
        if (kKey.isSimpleHierarchyLevel()) {
            throw new RuntimeException("Direct insertion of simple hierarchy entry is not supported.");
        }
        if (this.containsSimpleHierarchyInformation) {
            throw new RuntimeException("Combination of hierarchy (K51xx) and simple hierarchy (K2030/2031) is not supported.");
        }
        this.putEntryInternal(entry);
        this.containsHierarchyInformation = true;
    }

    private void putSimpleHierarchyEntry(KKey kKey, Integer index, Object value) {
        if (this.containsHierarchyInformation) {
            throw new RuntimeException("Combination of hierarchy (K51xx) and simple hierarchy (K2030/2031) is not supported.");
        }
        if (this.isCharacteristicSimpleGroupingParent(kKey)) {
            NodeIndex nodeIndex = NodeIndex.of((Integer)value);
            HierarchyEntry hierarchyEntry = new HierarchyEntry(KEY_CHARACTERISTIC_NODE, nodeIndex, index);
            this.putEntryInternal(hierarchyEntry);
        } else if (this.isCharacteristicSimpleGroupingChild(kKey)) {
            NodeIndex nodeIndex = NodeIndex.of((Integer)value);
            HierarchyEntry hierarchyEntry = new HierarchyEntry(KEY_CHARACTERISTIC_BINDING, nodeIndex, index);
            this.putEntryInternal(hierarchyEntry);
        } else {
            throw new IllegalArgumentException("Unknown simple hierarchy entry. Key: " + kKey + " Value: " + Objects.toString(value));
        }
        this.containsSimpleHierarchyInformation = true;
    }

    private void putEntryInternal(HierarchyEntry entry) {
        KKey kKey = entry.getKey();
        if (this.isNodeDefinition(kKey)) {
            this.nodeDefinitions.put((NodeIndex)entry.getIndex(), entry);
        } else if (this.isBinding(kKey)) {
            this.nodeBindings.computeIfAbsent((NodeIndex)entry.getIndex(), (Function<NodeIndex, List<HierarchyEntry>>)((Function<NodeIndex, List>)k -> new ArrayList())).add(entry);
        } else {
            throw new IllegalArgumentException("Unknown hierarchy entry. Key: " + kKey + " Value: " + Objects.toString(entry.getValue()));
        }
    }

    private boolean isBinding(KKey kKey) {
        return this.isNodeBinding(kKey) || this.isCharacteristicBinding(kKey);
    }

    private boolean isNodeBinding(KKey kKey) {
        return kKey.equals(KEY_NODE_BINDING);
    }

    private boolean isCharacteristicBinding(KKey kKey) {
        return kKey.equals(KEY_CHARACTERISTIC_BINDING);
    }

    private boolean isNodeDefinition(KKey kKey) {
        return this.isPartNode(kKey) || this.isCharacteristicNode(kKey) || this.isGroupNode(kKey);
    }

    private boolean isPartNode(KKey kKey) {
        return kKey.equals(KEY_PART_NODE);
    }

    private boolean isCharacteristicNode(KKey kKey) {
        return kKey.equals(KEY_CHARACTERISTIC_NODE);
    }

    private boolean isGroupNode(KKey kKey) {
        return kKey.equals(KEY_GROUP_NODE);
    }

    private boolean isCharacteristicSimpleGroupingParent(KKey kKey) {
        return kKey.equals(KEY_SIMPLE_GROUPING_CHARACTERISTIC_PARENT);
    }

    private boolean isCharacteristicSimpleGroupingChild(KKey kKey) {
        return kKey.equals(KEY_SIMPLE_GROUPING_CHARACTERISTIC_CHILD);
    }

    public void forEachNodeDefinition(Consumer<HierarchyEntry> action) {
        this.nodeDefinitions.values().forEach(action);
    }

    public void forEachNodeBinding(Consumer<HierarchyEntry> action) {
        this.nodeBindings.values().stream().flatMap(Collection::stream).forEach(action);
    }

    public boolean isEmpty() {
        return this.nodeDefinitions.isEmpty() && this.nodeBindings.isEmpty();
    }

    public boolean hasChildren(CharacteristicIndex characteristicIndex) {
        Optional<NodeIndex> nodeIndexOfCharacteristic = this.getNodeIndexOfCharacteristic(characteristicIndex);
        if (nodeIndexOfCharacteristic.isPresent()) {
            List<HierarchyEntry> children = this.nodeBindings.get(nodeIndexOfCharacteristic.get());
            return CollectionUtils.isNotEmpty(children);
        }
        return false;
    }

    public Optional<Object> getParentIndex(CharacteristicIndex characteristicIndex) {
        Optional<NodeIndex> parentNodeIndex;
        Optional<NodeIndex> parentNodeIndexOfCharacteristic = this.getParentNodeIndexOfCharacteristic(characteristicIndex);
        if (parentNodeIndexOfCharacteristic.isPresent()) {
            return this.getCharacteristicOrGroupIndexOfNode(parentNodeIndexOfCharacteristic.get(), characteristicIndex.getPartIndex());
        }
        Optional<NodeIndex> nodeIndexOfCharacteristic = this.getNodeIndexOfCharacteristic(characteristicIndex);
        if (nodeIndexOfCharacteristic.isPresent() && (parentNodeIndex = this.getParentNodeIndexOfNode(nodeIndexOfCharacteristic.get())).isPresent()) {
            return this.getCharacteristicOrGroupIndexOfNode(parentNodeIndex.get(), characteristicIndex.getPartIndex());
        }
        return Optional.empty();
    }

    public Optional<Object> getParentIndex(GroupIndex groupIndex) {
        Optional<NodeIndex> parentNodeIndex;
        Optional<NodeIndex> nodeIndexOfGroup = this.getNodeIndexOfGroup(groupIndex);
        if (nodeIndexOfGroup.isPresent() && (parentNodeIndex = this.getParentNodeIndexOfNode(nodeIndexOfGroup.get())).isPresent()) {
            return this.getCharacteristicOrGroupIndexOfNode(parentNodeIndex.get(), groupIndex.getPartIndex());
        }
        return Optional.empty();
    }

    private Optional<Object> getCharacteristicOrGroupIndexOfNode(NodeIndex nodeIndex, PartIndex partIndex) {
        HierarchyEntry nodeDefinition = this.nodeDefinitions.get(nodeIndex);
        Integer index = (Integer)nodeDefinition.getValue();
        if (nodeDefinition.getKey().equals(KEY_CHARACTERISTIC_NODE)) {
            return Optional.of(CharacteristicIndex.of(partIndex, index));
        }
        if (nodeDefinition.getKey().equals(KEY_GROUP_NODE)) {
            return Optional.of(GroupIndex.of(partIndex, index));
        }
        return Optional.empty();
    }

    private Optional<NodeIndex> getParentNodeIndexOfNode(NodeIndex nodeIndex) {
        return this.nodeBindings.values().stream().flatMap(list -> list.stream()).filter(hierarchyEntry -> hierarchyEntry.getKey().equals(KEY_NODE_BINDING) && nodeIndex.getIndex().equals(hierarchyEntry.getValue())).map(hierarchyEntry -> (NodeIndex)hierarchyEntry.getIndex()).findAny();
    }

    private Optional<NodeIndex> getParentNodeIndexOfCharacteristic(CharacteristicIndex characteristicIndex) {
        return this.nodeBindings.values().stream().flatMap(list -> list.stream()).filter(hierarchyEntry -> hierarchyEntry.getKey().equals(KEY_CHARACTERISTIC_BINDING) && characteristicIndex.getCharacteristicIndex().equals(hierarchyEntry.getValue())).map(hierarchyEntry -> (NodeIndex)hierarchyEntry.getIndex()).findAny();
    }

    private Optional<NodeIndex> getNodeIndexOfGroup(GroupIndex groupIndex) {
        Objects.requireNonNull(groupIndex);
        Objects.requireNonNull(groupIndex.getGroupIndex());
        Integer groupIndexInt = groupIndex.getGroupIndex();
        return this.nodeDefinitions.entrySet().stream().filter(entry -> {
            HierarchyEntry hierarchyEntry = (HierarchyEntry)entry.getValue();
            return KEY_GROUP_NODE.equals(hierarchyEntry.getKey()) && groupIndexInt.equals(hierarchyEntry.getValue());
        }).map(entry -> (NodeIndex)entry.getKey()).findAny();
    }

    private Optional<NodeIndex> getNodeIndexOfCharacteristic(CharacteristicIndex characteristicIndex) {
        Objects.requireNonNull(characteristicIndex);
        Objects.requireNonNull(characteristicIndex.getCharacteristicIndex());
        Integer characteristicIndexInt = characteristicIndex.getCharacteristicIndex();
        return this.nodeDefinitions.entrySet().stream().filter(entry -> {
            HierarchyEntry hierarchyEntry = (HierarchyEntry)entry.getValue();
            return KEY_CHARACTERISTIC_NODE.equals(hierarchyEntry.getKey()) && characteristicIndexInt.equals(hierarchyEntry.getValue());
        }).map(entry -> (NodeIndex)entry.getKey()).findAny();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.nodeBindings == null ? 0 : this.nodeBindings.hashCode());
        result = 31 * result + (this.nodeDefinitions == null ? 0 : this.nodeDefinitions.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AqdefHierarchy)) {
            return false;
        }
        AqdefHierarchy other = (AqdefHierarchy)obj;
        if (this.nodeBindings == null ? other.nodeBindings != null : !this.nodeBindings.equals(other.nodeBindings)) {
            return false;
        }
        return !(this.nodeDefinitions == null ? other.nodeDefinitions != null : !this.nodeDefinitions.equals(other.nodeDefinitions));
    }

    public static class HierarchyEntry
    extends AqdefObjectModel.AbstractEntry<NodeIndex> {
        public HierarchyEntry(KKey key, NodeIndex index, Integer value) {
            super(HierarchyEntry.validateKey(key), index, value);
        }

        private static KKey validateKey(KKey key) {
            if (!key.isHierarchyLevel()) {
                throw new IllegalArgumentException("K-Key of hierarchy type expected, but found: " + key);
            }
            return key;
        }
    }
}

