/*
 * Decompiled with CFR 0.152.
 */
package cz.diribet.aqdef;

import cz.diribet.aqdef.convert.BigDecimalKKeyValueConverter;
import cz.diribet.aqdef.convert.DateKKeyValueConverter;
import cz.diribet.aqdef.convert.IKKeyValueConverter;
import cz.diribet.aqdef.convert.IntegerKKeyValueConverter;
import cz.diribet.aqdef.convert.StringKKeyValueConverter;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Objects;
import java.util.UUID;
import org.apache.commons.lang3.builder.ToStringBuilder;

public final class KKeyMetadata {
    private final String columnName;
    private final Class<?> dataType;
    private final Integer length;
    private final IKKeyValueConverter<?> converter;
    private final boolean saveToDb;
    private final boolean respectsCharacteristicDecimalSettings;

    private KKeyMetadata(String columnName, Class<?> dataType, Integer length, IKKeyValueConverter<?> converter, boolean saveToDb, boolean respectsCharacteristicDecimalSettings) {
        Objects.requireNonNull(columnName);
        Objects.requireNonNull(dataType);
        Objects.requireNonNull(converter);
        this.columnName = columnName;
        this.dataType = dataType;
        this.length = length;
        this.converter = converter;
        this.saveToDb = saveToDb;
        this.respectsCharacteristicDecimalSettings = respectsCharacteristicDecimalSettings;
    }

    public static KKeyMetadataBuilder builder() {
        return new KKeyMetadataBuilder();
    }

    public static KKeyMetadata of(String columnName, Class<?> dataType) {
        return KKeyMetadata.of(columnName, dataType, null);
    }

    public static KKeyMetadata of(String columnName, Class<?> dataType, boolean saveToDb) {
        return KKeyMetadata.of(columnName, dataType, null, saveToDb);
    }

    public static KKeyMetadata of(String columnName, Class<?> dataType, Integer length) {
        return KKeyMetadata.of(columnName, dataType, length, true);
    }

    public static KKeyMetadata of(String columnName, Class<?> dataType, Integer length, boolean saveToDb) {
        return KKeyMetadata.builder().columnName(columnName).dataType(dataType).length(length).saveToDb(saveToDb).build();
    }

    public Integer getLength() {
        return this.length;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public Class<?> getDataType() {
        return this.dataType;
    }

    public IKKeyValueConverter<?> getConverter() {
        return this.converter;
    }

    public boolean isSaveToDb() {
        return this.saveToDb;
    }

    public boolean isRespectsCharacteristicDecimalSettings() {
        return this.respectsCharacteristicDecimalSettings;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.columnName == null ? 0 : this.columnName.hashCode());
        result = 31 * result + (this.dataType == null ? 0 : this.dataType.hashCode());
        result = 31 * result + (this.length == null ? 0 : this.length.hashCode());
        result = 31 * result + (this.saveToDb ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KKeyMetadata)) {
            return false;
        }
        KKeyMetadata other = (KKeyMetadata)obj;
        if (this.columnName == null ? other.columnName != null : !this.columnName.equals(other.columnName)) {
            return false;
        }
        if (this.dataType == null ? other.dataType != null : !this.dataType.equals(other.dataType)) {
            return false;
        }
        if (this.length == null ? other.length != null : !this.length.equals(other.length)) {
            return false;
        }
        return this.saveToDb == other.saveToDb;
    }

    public static final class KKeyMetadataBuilder {
        private String columnName;
        private Class<?> dataType;
        private Integer length;
        private IKKeyValueConverter<?> converter;
        private boolean saveToDb;
        private boolean respectsCharacteristicDecimalSettings;

        private KKeyMetadataBuilder() {
        }

        public KKeyMetadataBuilder columnName(String columnName) {
            this.columnName = columnName;
            return this;
        }

        public KKeyMetadataBuilder dataType(Class<?> dataType) {
            this.dataType = dataType;
            return this;
        }

        public <T> KKeyMetadataBuilder dataType(Class<T> dataType, IKKeyValueConverter<T> converter) {
            this.dataType = dataType;
            this.converter = converter;
            return this;
        }

        public KKeyMetadataBuilder length(Integer length) {
            this.length = length;
            return this;
        }

        public KKeyMetadataBuilder saveToDb(boolean saveToDb) {
            this.saveToDb = saveToDb;
            return this;
        }

        public KKeyMetadataBuilder respectsCharacteristicDecimalSettings(boolean respectsCharacteristicDecimalSettings) {
            this.respectsCharacteristicDecimalSettings = respectsCharacteristicDecimalSettings;
            return this;
        }

        public KKeyMetadata build() {
            if (this.converter == null) {
                this.converter = this.createDefaultValueConverter();
            }
            return new KKeyMetadata(this.columnName, this.dataType, this.length, this.converter, this.saveToDb, this.respectsCharacteristicDecimalSettings);
        }

        private IKKeyValueConverter<?> createDefaultValueConverter() {
            if (String.class.equals(this.dataType) || UUID.class.equals(this.dataType)) {
                return new StringKKeyValueConverter();
            }
            if (Integer.class.equals(this.dataType)) {
                return new IntegerKKeyValueConverter();
            }
            if (BigDecimal.class.equals(this.dataType)) {
                return new BigDecimalKKeyValueConverter();
            }
            if (Date.class.equals(this.dataType)) {
                return new DateKKeyValueConverter();
            }
            throw new IllegalArgumentException("There is no converter defined for data type: " + this.dataType.getName());
        }
    }
}

