/*
 * Decompiled with CFR 0.152.
 */
package cz.diribet.aqdef.model;

import cz.diribet.aqdef.KKey;
import cz.diribet.aqdef.model.IHasKKeyValues;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValueEntriesAggregator
implements IHasKKeyValues {
    private static final Logger LOG = LoggerFactory.getLogger(ValueEntriesAggregator.class);
    private final IHasKKeyValues partEntries;
    private final IHasKKeyValues characteristicEntries;
    private final IHasKKeyValues valueEntries;

    public ValueEntriesAggregator(IHasKKeyValues partEntries, IHasKKeyValues characteristicEntries, IHasKKeyValues valueEntries) {
        Objects.requireNonNull(partEntries);
        Objects.requireNonNull(characteristicEntries);
        Objects.requireNonNull(valueEntries);
        this.partEntries = partEntries;
        this.characteristicEntries = characteristicEntries;
        this.valueEntries = valueEntries;
    }

    @Override
    public <T> T getValue(KKey kKey) {
        KKey.Level level = kKey.getLevel();
        switch (level) {
            case PART: 
            case CUSTOM_PART: {
                return this.partEntries.getValue(kKey);
            }
            case CHARACTERISTIC: 
            case CUSTOM_CHARACTERISTIC: {
                return this.characteristicEntries.getValue(kKey);
            }
            case VALUE: 
            case CUSTOM_VALUE: {
                return this.valueEntries.getValue(kKey);
            }
        }
        LOG.warn("Unknown k-key level: " + kKey);
        return null;
    }

    public IHasKKeyValues getPartEntries() {
        return this.partEntries;
    }

    public IHasKKeyValues getCharacteristicEntries() {
        return this.characteristicEntries;
    }

    public IHasKKeyValues getValueEntries() {
        return this.valueEntries;
    }
}

