/*
 * Decompiled with CFR 0.152.
 */
package cz.diribet.aqdef;

import cz.diribet.aqdef.convert.BigDecimalKKeyValueConverter;
import cz.diribet.aqdef.convert.DateKKeyValueConverter;
import cz.diribet.aqdef.convert.IKKeyValueConverter;
import cz.diribet.aqdef.convert.IntegerKKeyValueConverter;
import cz.diribet.aqdef.convert.StringKKeyValueConverter;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Objects;
import java.util.UUID;
import org.apache.commons.lang3.builder.ToStringBuilder;

public final class KKeyMetadata {
    private final String columnName;
    private final Class<?> dataType;
    private final Integer length;
    private final IKKeyValueConverter<?> converter;
    private final boolean saveToDb;

    private KKeyMetadata(String columnName, Class<?> dataType, Integer length, IKKeyValueConverter<?> converter, boolean saveToDb) {
        Objects.requireNonNull(columnName);
        Objects.requireNonNull(dataType);
        Objects.requireNonNull(converter);
        this.columnName = columnName;
        this.dataType = dataType;
        this.length = length;
        this.converter = converter;
        this.saveToDb = saveToDb;
    }

    public static KKeyMetadata of(String columnName, Class<?> dataType) {
        return KKeyMetadata.of(columnName, dataType, (Integer)null);
    }

    public static KKeyMetadata of(String columnName, Class<?> dataType, boolean saveToDb) {
        return KKeyMetadata.of(columnName, dataType, (Integer)null, saveToDb);
    }

    public static KKeyMetadata of(String columnName, Class<?> dataType, Integer length) {
        return KKeyMetadata.of(columnName, dataType, length, true);
    }

    public static KKeyMetadata of(String columnName, Class<?> dataType, Integer length, boolean saveToDb) {
        IKKeyValueConverter<String> converter;
        if (String.class.equals(dataType) || UUID.class.equals(dataType)) {
            converter = new StringKKeyValueConverter();
        } else if (Integer.class.equals(dataType)) {
            converter = new IntegerKKeyValueConverter();
        } else if (BigDecimal.class.equals(dataType)) {
            converter = new BigDecimalKKeyValueConverter();
        } else if (Date.class.equals(dataType)) {
            converter = new DateKKeyValueConverter();
        } else {
            throw new IllegalArgumentException("There is no converter defined for data type: " + dataType.getName());
        }
        return new KKeyMetadata(columnName, dataType, length, converter, saveToDb);
    }

    public static <T> KKeyMetadata of(String columnName, Class<T> dataType, IKKeyValueConverter<T> converter) {
        return KKeyMetadata.of(columnName, dataType, converter, true);
    }

    public static <T> KKeyMetadata of(String columnName, Class<T> dataType, IKKeyValueConverter<T> converter, boolean saveToDb) {
        return new KKeyMetadata(columnName, dataType, null, converter, saveToDb);
    }

    public static <T> KKeyMetadata of(String columnName, Class<T> dataType, int length, IKKeyValueConverter<T> converter) {
        return new KKeyMetadata(columnName, dataType, length, converter, true);
    }

    public Integer getLength() {
        return this.length;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public Class<?> getDataType() {
        return this.dataType;
    }

    public IKKeyValueConverter<?> getConverter() {
        return this.converter;
    }

    public boolean isSaveToDb() {
        return this.saveToDb;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.columnName == null ? 0 : this.columnName.hashCode());
        result = 31 * result + (this.dataType == null ? 0 : this.dataType.hashCode());
        result = 31 * result + (this.length == null ? 0 : this.length.hashCode());
        result = 31 * result + (this.saveToDb ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KKeyMetadata)) {
            return false;
        }
        KKeyMetadata other = (KKeyMetadata)obj;
        if (this.columnName == null ? other.columnName != null : !this.columnName.equals(other.columnName)) {
            return false;
        }
        if (this.dataType == null ? other.dataType != null : !this.dataType.equals(other.dataType)) {
            return false;
        }
        if (this.length == null ? other.length != null : !this.length.equals(other.length)) {
            return false;
        }
        return this.saveToDb == other.saveToDb;
    }
}

