/*
 * Decompiled with CFR 0.152.
 */
package cz.diribet.aqdef.model.builder;

import cz.diribet.aqdef.KKey;
import cz.diribet.aqdef.model.AqdefObjectModel;
import cz.diribet.aqdef.model.CharacteristicIndex;
import cz.diribet.aqdef.model.GroupIndex;
import cz.diribet.aqdef.model.PartIndex;
import cz.diribet.aqdef.model.ValueIndex;
import cz.diribet.aqdef.model.builder.AqdefHierarchyBuilder;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class AqdefObjectModelBuilder {
    private final AqdefObjectModel aqdefObjectModel;
    private final AqdefHierarchyBuilder hierarchyBuilder;
    private final AtomicInteger partIndex = new AtomicInteger(1);
    private final AtomicInteger characteristicIndex = new AtomicInteger(1);
    private final AtomicInteger valueIndex = new AtomicInteger(1);
    private final AtomicInteger groupIndex = new AtomicInteger(1);
    private final AtomicInteger hierarchyNodeIndex = new AtomicInteger(1);

    public AqdefObjectModelBuilder() {
        this.aqdefObjectModel = new AqdefObjectModel();
        this.hierarchyBuilder = new AqdefHierarchyBuilder();
    }

    public AqdefObjectModel build() {
        this.aqdefObjectModel.setHierarchy(this.hierarchyBuilder.getHierarchy());
        return this.aqdefObjectModel;
    }

    public void createPartEntry(String key, Object value) {
        this.createPartEntry(KKey.of(key), value);
    }

    public void createPartEntry(KKey key, Object value) {
        if (value == null) {
            return;
        }
        this.aqdefObjectModel.putPartEntry(key, this.currentPartIndex(), value);
    }

    public void replacePartEntry(String key, int index, Object value) {
        KKey kKey = KKey.of(key);
        List<PartIndex> affectedPartIndexes = index == 0 ? this.aqdefObjectModel.getPartIndexes() : Collections.singletonList(PartIndex.of(index));
        affectedPartIndexes.forEach(partIndex -> this.aqdefObjectModel.putPartEntry(kKey, (PartIndex)partIndex, value));
    }

    public void createCharacteristicEntry(String key, Object value) {
        this.createCharacteristicEntry(KKey.of(key), value);
    }

    public void createCharacteristicEntry(KKey key, Object value) {
        if (value == null) {
            return;
        }
        this.aqdefObjectModel.putCharacteristicEntry(key, this.currentCharacteristicIndex(), value);
    }

    public void replaceCharacteristicEntry(String key, int partIndex, int characteristicIndex, Object value) {
        KKey kKey = KKey.of(key);
        List<PartIndex> affectedPartIndexes = partIndex == 0 ? this.aqdefObjectModel.getPartIndexes() : Collections.singletonList(PartIndex.of(partIndex));
        affectedPartIndexes.forEach(affectedPartIndex -> {
            List<CharacteristicIndex> affectedCharacteristicIndexes = characteristicIndex == 0 ? this.aqdefObjectModel.getCharacteristicIndexes((PartIndex)affectedPartIndex) : Collections.singletonList(CharacteristicIndex.of(affectedPartIndex, (Integer)characteristicIndex));
            affectedCharacteristicIndexes.forEach(affectedCharacteristicIndex -> this.aqdefObjectModel.putCharacteristicEntry(kKey, (CharacteristicIndex)affectedCharacteristicIndex, value));
        });
    }

    public void createGroupEntry(String key, Object value) {
        this.createGroupEntry(KKey.of(key), value);
    }

    public void createGroupEntry(KKey key, Object value) {
        if (value == null) {
            return;
        }
        this.aqdefObjectModel.putGroupEntry(key, this.currentGroupIndex(), value);
    }

    public void createValueEntry(String key, Object value) {
        this.createValueEntry(KKey.of(key), value);
    }

    public void createValueEntry(KKey key, Object value) {
        if (value == null) {
            return;
        }
        this.aqdefObjectModel.putValueEntry(key, this.currentValueIndex(), value);
    }

    public void createHierarchyNodeOfPart() {
        this.hierarchyBuilder.createHierarchyNodeOfPart(this.hierarchyNodeIndex.getAndIncrement(), this.partIndex.get());
    }

    public void createHierarchyNodeOfCharacteristic(int characteristicId, Integer parentCharacteristicId) {
        this.hierarchyBuilder.createHierarchyNodeOfCharacteristic(this.hierarchyNodeIndex.getAndIncrement(), this.partIndex.get(), this.characteristicIndex.get(), characteristicId, parentCharacteristicId);
    }

    public void createHierarchyNodeOfGroup(int characteristicId, Integer parentCharacteristicId) {
        this.hierarchyBuilder.createHierarchyNodeOfGroup(this.hierarchyNodeIndex.getAndIncrement(), this.partIndex.get(), this.groupIndex.get(), characteristicId, parentCharacteristicId);
    }

    public void nextPart() {
        this.partIndex.incrementAndGet();
    }

    public void nextCharacteristic() {
        this.characteristicIndex.incrementAndGet();
        this.valueIndex.set(1);
    }

    public void nextValue() {
        this.valueIndex.incrementAndGet();
    }

    public void nextGroup() {
        this.groupIndex.incrementAndGet();
    }

    private PartIndex currentPartIndex() {
        return PartIndex.of(this.partIndex.get());
    }

    private CharacteristicIndex currentCharacteristicIndex() {
        return CharacteristicIndex.of(this.currentPartIndex(), (Integer)this.characteristicIndex.get());
    }

    private GroupIndex currentGroupIndex() {
        return GroupIndex.of(this.currentPartIndex(), (Integer)this.groupIndex.get());
    }

    private ValueIndex currentValueIndex() {
        return ValueIndex.of(this.currentCharacteristicIndex(), this.valueIndex.get());
    }
}

