/*
 * Decompiled with CFR 0.152.
 */
package cz.diribet.aqdef;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import cz.diribet.aqdef.KKeyMetadata;
import cz.diribet.aqdef.KKeyRepository;
import cz.diribet.aqdef.catalog.CatalogField;
import cz.diribet.aqdef.convert.IKKeyValueConverter;
import java.io.Serializable;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class KKey
implements Serializable,
Comparable<KKey> {
    private static final Logger LOG = LoggerFactory.getLogger(KKey.class);
    private static final LoadingCache<String, KKey> CACHE = CacheBuilder.newBuilder().weakValues().build((CacheLoader)new CacheLoader<String, KKey>(){

        public KKey load(String key) throws Exception {
            return new KKey(key);
        }
    });
    private String key;
    private transient Level level;
    private transient KKeyMetadata metadata;

    private KKey(String key) {
        this.key = key;
    }

    public static KKey of(String key) {
        try {
            return (KKey)CACHE.get((Object)key);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public String getKey() {
        return this.key;
    }

    public IKKeyValueConverter<?> getConverter() {
        if (this.metadata == null) {
            this.metadata = this.findMetadata();
        }
        if (this.metadata == null || this.metadata.getConverter() == null) {
            LOG.error("Can't find converter for k-key: " + this.key);
            return null;
        }
        return this.metadata.getConverter();
    }

    public String getDbColumnName() {
        if (this.metadata == null) {
            this.metadata = this.findMetadata();
        }
        if (this.metadata == null || this.metadata.getColumnName() == null) {
            LOG.error("Can't find DB column name for k-key: " + this.key);
            return null;
        }
        return this.metadata.getColumnName();
    }

    public Class<?> getDataType() {
        if (this.metadata == null) {
            this.metadata = this.findMetadata();
        }
        if (this.metadata == null || this.metadata.getDataType() == null) {
            LOG.error("Can't find data type of k-key: " + this.key);
            return null;
        }
        return this.metadata.getDataType();
    }

    public boolean isRespectsCharacteristicDecimalSettings() {
        if (this.metadata == null) {
            this.metadata = this.findMetadata();
        }
        if (this.metadata == null) {
            LOG.error("Can't find metadata of k-key: " + this.key);
            return false;
        }
        return this.metadata.isRespectsCharacteristicDecimalSettings();
    }

    public KKeyMetadata getMetadata() {
        if (this.metadata == null) {
            this.metadata = this.findMetadata();
            if (this.metadata == null) {
                LOG.error("Can't find metadata for k-key: " + this.key);
                return null;
            }
        }
        return this.metadata;
    }

    private KKeyMetadata findMetadata() {
        if (this.getLevel() == Level.CATALOG) {
            return CatalogField.getMetadataFor(this);
        }
        return KKeyRepository.getInstance().getMetadataFor(this);
    }

    public Level getLevel() {
        if (this.level == null) {
            this.level = this.determineLevel();
        }
        return this.level;
    }

    private Level determineLevel() {
        if (this.key == null) {
            LOG.error("K-key with missing key.");
            return Level.UNKNOWN;
        }
        if (this.key.equalsIgnoreCase("K2030") || this.key.equalsIgnoreCase("K2031")) {
            return Level.SIMPLE_HIERARCHY;
        }
        if (this.key.startsWith("K1")) {
            return Level.PART;
        }
        if (this.key.startsWith("K2") || this.key.startsWith("K8")) {
            return Level.CHARACTERISTIC;
        }
        if (this.key.startsWith("K0")) {
            return Level.VALUE;
        }
        if (this.key.startsWith("K4")) {
            return Level.CATALOG;
        }
        if (this.key.startsWith("K50")) {
            return Level.GROUP;
        }
        if (this.key.startsWith("K51")) {
            return Level.HIERARCHY;
        }
        if (this.key.startsWith("KX0")) {
            return Level.CUSTOM_VALUE;
        }
        if (this.key.startsWith("KX2")) {
            return Level.CUSTOM_CHARACTERISTIC;
        }
        if (this.key.startsWith("KX1")) {
            return Level.CUSTOM_PART;
        }
        LOG.error("Unknown level of k-key " + this.key);
        return Level.UNKNOWN;
    }

    public boolean isPartLevel() {
        return this.getLevel() == Level.PART;
    }

    public boolean isCustomPartLevel() {
        return this.getLevel() == Level.CUSTOM_PART;
    }

    public boolean isCharacteristicLevel() {
        return this.getLevel() == Level.CHARACTERISTIC;
    }

    public boolean isCustomCharacteristicLevel() {
        return this.getLevel() == Level.CUSTOM_CHARACTERISTIC;
    }

    public boolean isValueLevel() {
        return this.getLevel() == Level.VALUE;
    }

    public boolean isCustomValueLevel() {
        return this.getLevel() == Level.CUSTOM_VALUE;
    }

    public boolean isGroupLevel() {
        return this.getLevel() == Level.GROUP;
    }

    public boolean isHierarchyLevel() {
        return this.getLevel() == Level.HIERARCHY;
    }

    public boolean isSimpleHierarchyLevel() {
        return this.getLevel() == Level.SIMPLE_HIERARCHY;
    }

    public boolean isCustom() {
        return this.isCustomPartLevel() || this.isCustomCharacteristicLevel() || this.isCustomValueLevel();
    }

    public boolean shouldBeWrittenToDfq() {
        return !this.isCustom();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KKey)) {
            return false;
        }
        KKey other = (KKey)obj;
        return !(this.key == null ? other.key != null : !this.key.equals(other.key));
    }

    public String toString() {
        return this.key;
    }

    @Override
    public int compareTo(KKey o) {
        if (this.key == null && o.key == null) {
            return 0;
        }
        if (this.key == null && o.key != null) {
            return 1;
        }
        if (this.key != null && o.key == null) {
            return -1;
        }
        String thisKey = this.keyForCompare(this.key);
        String otherKey = this.keyForCompare(o.key);
        return thisKey.compareTo(otherKey);
    }

    private String keyForCompare(String key) {
        if (key.equals("K0020")) {
            return "K0001.20";
        }
        if (key.equals("K0021")) {
            return "K0001.21";
        }
        return key;
    }

    public static enum Level {
        PART,
        CHARACTERISTIC,
        VALUE,
        CUSTOM_PART,
        CUSTOM_CHARACTERISTIC,
        CUSTOM_VALUE,
        GROUP,
        HIERARCHY,
        SIMPLE_HIERARCHY,
        CATALOG,
        UNKNOWN;

    }
}

