/*
 * Decompiled with CFR 0.152.
 */
package cz.diribet.aqdef.model;

import cz.diribet.aqdef.KKey;
import cz.diribet.aqdef.model.AqdefHierarchy;
import cz.diribet.aqdef.model.CharacteristicIndex;
import cz.diribet.aqdef.model.GroupIndex;
import cz.diribet.aqdef.model.IHasKKeyValues;
import cz.diribet.aqdef.model.PartIndex;
import cz.diribet.aqdef.model.ValueIndex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.collections4.MapUtils;

public class AqdefObjectModel {
    private Map<PartIndex, PartEntries> partEntries = this.newEntriesMap();
    private Map<PartIndex, Map<CharacteristicIndex, CharacteristicEntries>> characteristicEntries = this.newEntriesMap();
    private Map<PartIndex, Map<GroupIndex, GroupEntries>> groupEntries = this.newEntriesMap();
    private Map<PartIndex, Map<CharacteristicIndex, Map<ValueIndex, ValueEntries>>> valueEntries = this.newEntriesMap();
    private AqdefHierarchy hierarchy = new AqdefHierarchy();

    public void putPartEntry(KKey key, PartIndex index, Object value) {
        if (value == null) {
            return;
        }
        PartEntries entriesWithIndex = this.partEntries.computeIfAbsent(index, PartEntries::new);
        entriesWithIndex.put(key, value);
    }

    public void putPartEntries(PartEntries newPartEntries) {
        PartEntries entriesWithIndex = this.partEntries.computeIfAbsent((PartIndex)newPartEntries.getIndex(), PartEntries::new);
        entriesWithIndex.putAll(newPartEntries, true);
    }

    private PartEntries removePartEntries(PartIndex index) {
        return this.partEntries.remove(index);
    }

    public void putCharacteristicEntry(KKey key, CharacteristicIndex characteristicIndex, Object value) {
        if (value == null) {
            return;
        }
        CharacteristicEntries entriesWithIndex = this.computeCharacteristicEntriesIfAbsent(characteristicIndex);
        entriesWithIndex.put(key, value);
    }

    public void putCharacteristicEntries(CharacteristicEntries newCharacteristicEntries) {
        CharacteristicIndex characteristicIndex = (CharacteristicIndex)newCharacteristicEntries.getIndex();
        CharacteristicEntries entriesWithIndex = this.computeCharacteristicEntriesIfAbsent(characteristicIndex);
        entriesWithIndex.putAll(newCharacteristicEntries, true);
    }

    private CharacteristicEntries computeCharacteristicEntriesIfAbsent(CharacteristicIndex characteristicIndex) {
        PartIndex partIndex = characteristicIndex.getPartIndex();
        Map entriesWithPartIndex = this.characteristicEntries.computeIfAbsent(partIndex, i -> this.newEntriesMap());
        return entriesWithPartIndex.computeIfAbsent(characteristicIndex, CharacteristicEntries::new);
    }

    private CharacteristicEntries removeCharacteristicEntries(CharacteristicIndex index) {
        Map<CharacteristicIndex, CharacteristicEntries> entriesWithPartIndex = this.characteristicEntries.get(index.getPartIndex());
        if (entriesWithPartIndex != null) {
            CharacteristicEntries removedEntries = entriesWithPartIndex.remove(index);
            if (entriesWithPartIndex.isEmpty()) {
                this.characteristicEntries.remove(index.getPartIndex());
            }
            return removedEntries;
        }
        return null;
    }

    public void putGroupEntry(KKey key, GroupIndex groupIndex, Object value) {
        if (value == null) {
            return;
        }
        PartIndex partIndex = groupIndex.getPartIndex();
        Map entriesWithPartIndex = this.groupEntries.computeIfAbsent(partIndex, i -> this.newEntriesMap());
        GroupEntries entriesWithIndex = entriesWithPartIndex.computeIfAbsent(groupIndex, GroupEntries::new);
        entriesWithIndex.put(key, value);
    }

    public void putValueEntry(KKey key, ValueIndex valueIndex, Object value) {
        if (value == null) {
            return;
        }
        ValueEntries entriesWithIndex = this.computeValueEntriesIfAbsent(valueIndex);
        entriesWithIndex.put(key, value);
    }

    public void putValueEntries(ValueEntries newValueEntries) {
        ValueIndex valueIndex = (ValueIndex)newValueEntries.getIndex();
        ValueEntries entriesWithIndex = this.computeValueEntriesIfAbsent(valueIndex);
        entriesWithIndex.putAll(newValueEntries, true);
    }

    private ValueEntries computeValueEntriesIfAbsent(ValueIndex valueIndex) {
        PartIndex partIndex = valueIndex.getPartIndex();
        Map entriesWithPartIndex = this.valueEntries.computeIfAbsent(partIndex, i -> this.newEntriesMap());
        CharacteristicIndex characteristicIndex = valueIndex.getCharacteristicIndex();
        Map entriesWithCharacteristicIndex = entriesWithPartIndex.computeIfAbsent(characteristicIndex, i -> this.newEntriesMap());
        return entriesWithCharacteristicIndex.computeIfAbsent(valueIndex, ValueEntries::new);
    }

    private List<ValueEntries> removeValueEntries(CharacteristicIndex index) {
        Map<CharacteristicIndex, Map<ValueIndex, ValueEntries>> entriesWithPartIndex = this.valueEntries.get(index.getPartIndex());
        if (entriesWithPartIndex != null) {
            Map<ValueIndex, ValueEntries> removedValueEntries = entriesWithPartIndex.remove(index);
            if (entriesWithPartIndex.isEmpty()) {
                this.valueEntries.remove(index.getPartIndex());
            }
            if (removedValueEntries != null) {
                return new ArrayList<ValueEntries>(removedValueEntries.values());
            }
        }
        return new ArrayList<ValueEntries>();
    }

    public void putHierarchyEntry(KKey kKey, Integer nodeIndex, Object value) {
        this.hierarchy.putEntry(kKey, nodeIndex, value);
    }

    public List<PartIndex> getPartIndexes() {
        return new ArrayList<PartIndex>(this.partEntries.keySet());
    }

    public PartEntries getPartEntries(int index) {
        return this.getPartEntries(PartIndex.of(index));
    }

    public PartEntries getPartEntries(PartIndex index) {
        return this.partEntries.get(index);
    }

    public List<CharacteristicIndex> getCharacteristicIndexes(PartIndex partIndex) {
        Map<CharacteristicIndex, CharacteristicEntries> entriesWithPartIndex = this.characteristicEntries.get(partIndex);
        if (entriesWithPartIndex == null) {
            return new ArrayList<CharacteristicIndex>();
        }
        return new ArrayList<CharacteristicIndex>(entriesWithPartIndex.keySet());
    }

    public CharacteristicEntries getCharacteristicEntries(int partIndex, int characteristicIndex) {
        return this.getCharacteristicEntries(CharacteristicIndex.of(PartIndex.of(partIndex), (Integer)characteristicIndex));
    }

    public CharacteristicEntries getCharacteristicEntries(CharacteristicIndex characteristicIndex) {
        Map<CharacteristicIndex, CharacteristicEntries> entriesWithPartIndex = this.characteristicEntries.get(characteristicIndex.getPartIndex());
        if (entriesWithPartIndex == null) {
            return null;
        }
        return entriesWithPartIndex.get(characteristicIndex);
    }

    public List<ValueIndex> getValueIndexes(CharacteristicIndex characteristicIndex) {
        Map<CharacteristicIndex, Map<ValueIndex, ValueEntries>> entriesWithPartIndex = this.valueEntries.get(characteristicIndex.getPartIndex());
        if (entriesWithPartIndex == null) {
            return new ArrayList<ValueIndex>();
        }
        Map<ValueIndex, ValueEntries> entriesWithCharacteristicIndex = entriesWithPartIndex.get(characteristicIndex);
        if (entriesWithCharacteristicIndex == null) {
            return new ArrayList<ValueIndex>();
        }
        return new ArrayList<ValueIndex>(entriesWithCharacteristicIndex.keySet());
    }

    public List<ValueIndex> getValueIndexes() {
        ArrayList<ValueIndex> allValueIndexes = new ArrayList<ValueIndex>();
        for (Map<CharacteristicIndex, Map<ValueIndex, ValueEntries>> entriesOfPart : this.valueEntries.values()) {
            for (Map<ValueIndex, ValueEntries> entriesOfCharacteristic : entriesOfPart.values()) {
                allValueIndexes.addAll(entriesOfCharacteristic.keySet());
            }
        }
        return allValueIndexes;
    }

    public ValueEntries getValueEntries(int partIndex, int characteristicIndex, int valueIndex) {
        return this.getValueEntries(ValueIndex.of(CharacteristicIndex.of(PartIndex.of(partIndex), (Integer)characteristicIndex), valueIndex));
    }

    public ValueEntries getValueEntries(ValueIndex valueIndex) {
        Map<CharacteristicIndex, Map<ValueIndex, ValueEntries>> entriesWithPartIndex = this.valueEntries.get(valueIndex.getPartIndex());
        if (entriesWithPartIndex == null) {
            return null;
        }
        Map<ValueIndex, ValueEntries> entriesWithCharacteristicIndex = entriesWithPartIndex.get(valueIndex.getCharacteristicIndex());
        if (entriesWithCharacteristicIndex == null) {
            return null;
        }
        return entriesWithCharacteristicIndex.get(valueIndex);
    }

    public List<ValueEntries> getValueEntries(CharacteristicIndex characteristicIndex) {
        Map<CharacteristicIndex, Map<ValueIndex, ValueEntries>> entriesWithPartIndex = this.valueEntries.get(characteristicIndex.getPartIndex());
        if (entriesWithPartIndex == null) {
            return new ArrayList<ValueEntries>();
        }
        Map<ValueIndex, ValueEntries> entriesWithCharacteristicIndex = entriesWithPartIndex.get(characteristicIndex);
        if (entriesWithCharacteristicIndex == null) {
            return new ArrayList<ValueEntries>();
        }
        return new ArrayList<ValueEntries>(entriesWithCharacteristicIndex.values());
    }

    public List<ValueSet> getValueSets(PartIndex partIndex) {
        Map<CharacteristicIndex, Map<ValueIndex, ValueEntries>> entriesWithPartIndex = this.valueEntries.get(partIndex);
        ArrayList<ValueSet> valueSets = new ArrayList<ValueSet>();
        for (Map.Entry<CharacteristicIndex, Map<ValueIndex, ValueEntries>> entriesOfCharacteristic : entriesWithPartIndex.entrySet()) {
            CharacteristicIndex characteristicIndex = entriesOfCharacteristic.getKey();
            Map<ValueIndex, ValueEntries> valuesOfCharacteristic = entriesOfCharacteristic.getValue();
            int counter = 0;
            for (Map.Entry<ValueIndex, ValueEntries> valueEntries : valuesOfCharacteristic.entrySet()) {
                while (counter >= valueSets.size()) {
                    valueSets.add(new ValueSet());
                }
                ValueSet valueSet = (ValueSet)valueSets.get(counter);
                valueSet.addValueOfCharacteristic(characteristicIndex, valueEntries.getValue());
                ++counter;
            }
        }
        return valueSets;
    }

    public PartIndex findPartIndexForCharacteristic(int characteristicIndex) {
        for (Map<CharacteristicIndex, CharacteristicEntries> characteristics : this.characteristicEntries.values()) {
            for (CharacteristicIndex characteristic : characteristics.keySet()) {
                if (characteristic.getCharacteristicIndex() != characteristicIndex) continue;
                return characteristic.getPartIndex();
            }
        }
        return null;
    }

    public Set<CharacteristicIndex> findCharacteristicIndexesForPart(PartIndex partIndex, CharacteristicOfSinglePartPredicate predicate) {
        HashSet<CharacteristicIndex> characteristicIndexes = new HashSet<CharacteristicIndex>();
        Map<CharacteristicIndex, CharacteristicEntries> partCharacteristics = this.characteristicEntries.get(partIndex);
        if (partCharacteristics != null) {
            for (CharacteristicEntries entries : partCharacteristics.values()) {
                if (!predicate.test(entries)) continue;
                characteristicIndexes.add((CharacteristicIndex)entries.getIndex());
            }
        }
        return characteristicIndexes;
    }

    public void forEachPart(PartConsumer consumer) {
        this.partEntries.forEach((partIndex, part) -> consumer.accept((PartEntries)part));
    }

    public void forEachCharacteristic(CharacteristicConsumer consumer) {
        this.partEntries.forEach((partIndex, part) -> {
            Map<CharacteristicIndex, CharacteristicEntries> characteristicsOfPart = this.characteristicEntries.get(part.getIndex());
            if (characteristicsOfPart != null) {
                characteristicsOfPart.forEach((characteristicIndex, characteristic) -> consumer.accept((PartEntries)part, (CharacteristicEntries)characteristic));
            }
        });
    }

    public void forEachCharacteristic(PartEntries part, CharacteristicOfSinglePartConsumer consumer) {
        Map<CharacteristicIndex, CharacteristicEntries> characteristicsOfPart = this.characteristicEntries.get(part.getIndex());
        if (characteristicsOfPart != null) {
            characteristicsOfPart.forEach((characteristicIndex, characteristic) -> consumer.accept((CharacteristicEntries)characteristic));
        }
    }

    public void forEachGroup(GroupConsumer consumer) {
        this.partEntries.forEach((partIndex, part) -> {
            Map<GroupIndex, GroupEntries> groupsOfPart = this.groupEntries.get(part.getIndex());
            if (groupsOfPart != null) {
                groupsOfPart.forEach((groupIndex, group) -> consumer.accept((PartEntries)part, (GroupEntries)group));
            }
        });
    }

    public void forEachGroup(PartEntries part, GroupOfSinglePartConsumer consumer) {
        Map<GroupIndex, GroupEntries> groupsOfPart = this.groupEntries.get(part.getIndex());
        if (groupsOfPart != null) {
            groupsOfPart.forEach((groupIndex, group) -> consumer.accept((GroupEntries)group));
        }
    }

    public void forEachValue(ValueConsumer consumer) {
        this.partEntries.forEach((partIndex, part) -> {
            Map<CharacteristicIndex, CharacteristicEntries> characteristicsOfPart = this.characteristicEntries.get(part.getIndex());
            if (characteristicsOfPart != null) {
                characteristicsOfPart.forEach((characteristicIndex, characteristic) -> {
                    Map<ValueIndex, ValueEntries> values;
                    Map<CharacteristicIndex, Map<ValueIndex, ValueEntries>> valuesOfPart = this.valueEntries.get(part.getIndex());
                    if (valuesOfPart != null && (values = valuesOfPart.get(characteristic.getIndex())) != null) {
                        values.forEach((valueIndex, value) -> consumer.accept((PartEntries)part, (CharacteristicEntries)characteristic, (ValueEntries)value));
                    }
                });
            }
        });
    }

    public void forEachValue(PartEntries part, ValueOfSinglePartConsumer consumer) {
        Map<CharacteristicIndex, CharacteristicEntries> characteristicsOfPart = this.characteristicEntries.get(part.getIndex());
        if (characteristicsOfPart != null) {
            characteristicsOfPart.forEach((characteristicIndex, characteristic) -> {
                Map<ValueIndex, ValueEntries> values;
                Map<CharacteristicIndex, Map<ValueIndex, ValueEntries>> valuesOfPart = this.valueEntries.get(part.getIndex());
                if (valuesOfPart != null && (values = valuesOfPart.get(characteristic.getIndex())) != null) {
                    values.forEach((valueIndex, value) -> consumer.accept((CharacteristicEntries)characteristic, (ValueEntries)value));
                }
            });
        }
    }

    public void forEachValue(PartEntries part, CharacteristicEntries characteristic, ValueOfSingleCharacteristicConsumer consumer) {
        Map<ValueIndex, ValueEntries> values;
        Map<CharacteristicIndex, Map<ValueIndex, ValueEntries>> valuesOfPart = this.valueEntries.get(part.getIndex());
        if (valuesOfPart != null && (values = valuesOfPart.get(characteristic.getIndex())) != null) {
            values.forEach((valueIndex, value) -> consumer.accept((ValueEntries)value));
        }
    }

    public void filterParts(PartPredicate predicate) {
        Iterator<Map.Entry<PartIndex, PartEntries>> iterator = this.partEntries.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<PartIndex, PartEntries> entry = iterator.next();
            PartIndex partIndex = entry.getKey();
            PartEntries part = entry.getValue();
            if (predicate.test(part)) continue;
            iterator.remove();
            this.characteristicEntries.remove(partIndex);
            this.valueEntries.remove(partIndex);
        }
    }

    public void filterCharacteristics(CharacteristicPredicate predicate) {
        this.partEntries.forEach((partIndex, part) -> {
            Map<CharacteristicIndex, CharacteristicEntries> characteristicsOfPart = this.characteristicEntries.get(part.getIndex());
            if (characteristicsOfPart != null) {
                Iterator<Map.Entry<CharacteristicIndex, CharacteristicEntries>> iterator = characteristicsOfPart.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<CharacteristicIndex, CharacteristicEntries> entry = iterator.next();
                    CharacteristicIndex characteristicIndex = entry.getKey();
                    CharacteristicEntries characteristic = entry.getValue();
                    if (predicate.test((PartEntries)part, characteristic)) continue;
                    iterator.remove();
                    this.removeValueEntries(characteristicIndex);
                }
            }
        });
    }

    public void filterCharacteristics(PartEntries part, CharacteristicOfSinglePartPredicate predicate) {
        Map<CharacteristicIndex, CharacteristicEntries> characteristicsOfPart = this.characteristicEntries.get(part.getIndex());
        if (characteristicsOfPart != null) {
            Iterator<Map.Entry<CharacteristicIndex, CharacteristicEntries>> iterator = characteristicsOfPart.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<CharacteristicIndex, CharacteristicEntries> entry = iterator.next();
                CharacteristicIndex characteristicIndex = entry.getKey();
                CharacteristicEntries characteristic = entry.getValue();
                if (predicate.test(characteristic)) continue;
                iterator.remove();
                this.removeValueEntries(characteristicIndex);
            }
        }
    }

    public void filterGroups(GroupPredicate predicate) {
        this.partEntries.forEach((partIndex, part) -> {
            Map<GroupIndex, GroupEntries> groupsOfPart = this.groupEntries.get(part.getIndex());
            if (groupsOfPart != null) {
                Iterator<Map.Entry<GroupIndex, GroupEntries>> iterator = groupsOfPart.entrySet().iterator();
                while (iterator.hasNext()) {
                    GroupEntries group = iterator.next().getValue();
                    if (predicate.test((PartEntries)part, group)) continue;
                    iterator.remove();
                }
            }
        });
    }

    public void filterGroups(PartEntries part, GroupOfSinglePartPredicate predicate) {
        Map<GroupIndex, GroupEntries> groupsOfPart = this.groupEntries.get(part.getIndex());
        if (groupsOfPart != null) {
            Iterator<Map.Entry<GroupIndex, GroupEntries>> iterator = groupsOfPart.entrySet().iterator();
            while (iterator.hasNext()) {
                GroupEntries group = iterator.next().getValue();
                if (predicate.test(group)) continue;
                iterator.remove();
            }
        }
    }

    public void filterValues(ValuePredicate predicate) {
        this.partEntries.forEach((partIndex, part) -> {
            Map<CharacteristicIndex, CharacteristicEntries> characteristicsOfPart = this.characteristicEntries.get(part.getIndex());
            if (characteristicsOfPart != null) {
                characteristicsOfPart.forEach((characteristicIndex, characteristic) -> {
                    Map<ValueIndex, ValueEntries> values;
                    Map<CharacteristicIndex, Map<ValueIndex, ValueEntries>> valuesOfPart = this.valueEntries.get(part.getIndex());
                    if (valuesOfPart != null && (values = valuesOfPart.get(characteristic.getIndex())) != null) {
                        Iterator<Map.Entry<ValueIndex, ValueEntries>> iterator = values.entrySet().iterator();
                        while (iterator.hasNext()) {
                            Map.Entry<ValueIndex, ValueEntries> entry = iterator.next();
                            ValueEntries value = entry.getValue();
                            if (predicate.test((PartEntries)part, (CharacteristicEntries)characteristic, value)) continue;
                            iterator.remove();
                        }
                    }
                });
            }
        });
    }

    public void filterValues(PartEntries part, ValueOfSinglePartPredicate predicate) {
        Map<CharacteristicIndex, CharacteristicEntries> characteristicsOfPart = this.characteristicEntries.get(part.getIndex());
        if (characteristicsOfPart != null) {
            characteristicsOfPart.forEach((characteristicIndex, characteristic) -> {
                Map<ValueIndex, ValueEntries> values;
                Map<CharacteristicIndex, Map<ValueIndex, ValueEntries>> valuesOfPart = this.valueEntries.get(part.getIndex());
                if (valuesOfPart != null && (values = valuesOfPart.get(characteristic.getIndex())) != null) {
                    Iterator<Map.Entry<ValueIndex, ValueEntries>> iterator = values.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry<ValueIndex, ValueEntries> entry = iterator.next();
                        ValueEntries value = entry.getValue();
                        if (predicate.test((CharacteristicEntries)characteristic, value)) continue;
                        iterator.remove();
                    }
                }
            });
        }
    }

    public void filterValues(PartEntries part, CharacteristicEntries characteristic, ValueOfSingleCharacteristicPredicate predicate) {
        Map<ValueIndex, ValueEntries> values;
        Map<CharacteristicIndex, Map<ValueIndex, ValueEntries>> valuesOfPart = this.valueEntries.get(part.getIndex());
        if (valuesOfPart != null && (values = valuesOfPart.get(characteristic.getIndex())) != null) {
            Iterator<Map.Entry<ValueIndex, ValueEntries>> iterator = values.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<ValueIndex, ValueEntries> entry = iterator.next();
                ValueEntries value = entry.getValue();
                if (predicate.test(value)) continue;
                iterator.remove();
            }
        }
    }

    public Object getAnyValueOf(KKey key) {
        if (key.isPartLevel()) {
            return this.partEntries.values().stream().findAny().map(entries -> entries.getValue(key)).orElse(null);
        }
        if (key.isCharacteristicLevel()) {
            return this.characteristicEntries.values().stream().findAny().map(entriesOfPart -> entriesOfPart.values().stream().findAny().map(entries -> entries.getValue(key)).orElse(null)).orElse(null);
        }
        if (key.isGroupLevel()) {
            return this.groupEntries.values().stream().findAny().map(entriesOfPart -> entriesOfPart.values().stream().findAny().map(entries -> entries.getValue(key)).orElse(null)).orElse(null);
        }
        if (key.isValueLevel()) {
            return this.valueEntries.values().stream().findAny().map(entriesOfPart -> entriesOfPart.values().stream().findAny().map(entriesOfCharacteristic -> entriesOfCharacteristic.values().stream().findAny().map(entries -> entries.getValue(key)).orElse(null)).orElse(null)).orElse(null);
        }
        throw new IllegalArgumentException(String.format("Invalid k-key %s. Value can be obtained only for part / characteristic / value keys.", key));
    }

    public void normalize() {
        PartEntries entriesForAllParts = this.removePartEntries(PartIndex.of(0));
        if (MapUtils.isNotEmpty((Map)entriesForAllParts)) {
            if (this.getPartIndexes().isEmpty()) {
                PartIndex partIndex = PartIndex.of(1);
                this.partEntries.put(partIndex, entriesForAllParts.withIndex(partIndex));
            } else {
                this.forEachPart(part -> part.putAll(entriesForAllParts.withIndex((PartIndex)part.getIndex()), false));
            }
        }
        CharacteristicIndex indexForAllCharacteristicsOfAllParts = CharacteristicIndex.of(PartIndex.of(0), (Integer)0);
        CharacteristicEntries entriesForAllCharacteristicsOfAllParts = new CharacteristicEntries(indexForAllCharacteristicsOfAllParts);
        CharacteristicEntries characteristicEntriesForAllCharacteristicsOfAllParts = this.removeCharacteristicEntries(indexForAllCharacteristicsOfAllParts);
        if (MapUtils.isNotEmpty((Map)characteristicEntriesForAllCharacteristicsOfAllParts)) {
            entriesForAllCharacteristicsOfAllParts.putAll(characteristicEntriesForAllCharacteristicsOfAllParts, false);
        }
        List<ValueEntries> entriesForAllValuesOfAllParts = this.removeValueEntries(indexForAllCharacteristicsOfAllParts);
        Map<Integer, List<ValueEntries>> entriesForAllValuesByValueIndex = entriesForAllValuesOfAllParts.stream().collect(Collectors.groupingBy(e -> ((ValueIndex)e.getIndex()).getValueIndex()));
        this.forEachPart(part -> {
            CharacteristicIndex indexForAllCharacteristics = CharacteristicIndex.of((PartIndex)part.getIndex(), (Integer)0);
            CharacteristicEntries entriesForAllCharacteristics = this.removeCharacteristicEntries(indexForAllCharacteristics);
            if (MapUtils.isNotEmpty((Map)entriesForAllCharacteristics)) {
                entriesForAllCharacteristicsOfAllParts.putAll(entriesForAllCharacteristics, false);
            }
        });
        this.forEachCharacteristic((part, characteristic) -> {
            characteristic.putAll(entriesForAllCharacteristicsOfAllParts.withIndex((CharacteristicIndex)characteristic.getIndex()), false);
            this.forEachValue(part, characteristic, value -> {
                List entriesForValueIndex = (List)entriesForAllValuesByValueIndex.get(((ValueIndex)value.getIndex()).getValueIndex());
                if (entriesForValueIndex != null) {
                    for (ValueEntries valueEntries : entriesForValueIndex) {
                        value.putAll(valueEntries.withIndex((ValueIndex)value.getIndex()), false);
                    }
                }
            });
        });
        this.hierarchy = this.hierarchy.normalize(this);
    }

    public int getCharacteristicCount() {
        AtomicInteger characteristicCount = new AtomicInteger();
        this.forEachCharacteristic((part, characteristic) -> characteristicCount.incrementAndGet());
        return characteristicCount.get();
    }

    public int getValueCount() {
        AtomicInteger count = new AtomicInteger();
        this.forEachValue((part, characteristic, value) -> count.incrementAndGet());
        return count.get();
    }

    private <K, V> Map<K, V> newEntriesMap() {
        return new ConcurrentSkipListMap();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.characteristicEntries == null ? 0 : this.characteristicEntries.hashCode());
        result = 31 * result + (this.groupEntries == null ? 0 : this.groupEntries.hashCode());
        result = 31 * result + (this.hierarchy == null ? 0 : this.hierarchy.hashCode());
        result = 31 * result + (this.partEntries == null ? 0 : this.partEntries.hashCode());
        result = 31 * result + (this.valueEntries == null ? 0 : this.valueEntries.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AqdefObjectModel)) {
            return false;
        }
        AqdefObjectModel other = (AqdefObjectModel)obj;
        if (this.characteristicEntries == null ? other.characteristicEntries != null : !this.characteristicEntries.equals(other.characteristicEntries)) {
            return false;
        }
        if (this.groupEntries == null ? other.groupEntries != null : !this.groupEntries.equals(other.groupEntries)) {
            return false;
        }
        if (this.hierarchy == null ? other.hierarchy != null : !this.hierarchy.equals(other.hierarchy)) {
            return false;
        }
        if (this.partEntries == null ? other.partEntries != null : !this.partEntries.equals(other.partEntries)) {
            return false;
        }
        return !(this.valueEntries == null ? other.valueEntries != null : !this.valueEntries.equals(other.valueEntries));
    }

    public AqdefHierarchy getHierarchy() {
        return this.hierarchy;
    }

    public void setHierarchy(AqdefHierarchy hierarchy) {
        this.hierarchy = hierarchy;
    }

    public static class ValueSet {
        private final TreeMap<CharacteristicIndex, ValueEntries> valuesOfCharacteristics;

        public ValueSet() {
            this(new TreeMap<CharacteristicIndex, ValueEntries>());
        }

        public ValueSet(TreeMap<CharacteristicIndex, ValueEntries> valuesOfCharacteristics) {
            this.valuesOfCharacteristics = valuesOfCharacteristics;
        }

        public void addValueOfCharacteristic(CharacteristicIndex characteristicIndex, ValueEntries valueEntries) {
            this.valuesOfCharacteristics.put(characteristicIndex, valueEntries);
        }

        public List<CharacteristicIndex> getCharacteristicIndexes() {
            return new ArrayList<CharacteristicIndex>(this.valuesOfCharacteristics.keySet());
        }

        public ValueEntries getValuesOfCharacteristic(CharacteristicIndex characteristicIndex) {
            return this.valuesOfCharacteristics.get(characteristicIndex);
        }

        public List<ValueEntries> getValues() {
            return new ArrayList<ValueEntries>(this.valuesOfCharacteristics.values());
        }
    }

    public static class GroupEntry
    extends AbstractEntry<GroupIndex> {
        public GroupEntry(KKey key, GroupIndex index, Object value) {
            super(GroupEntry.validateKey(key), index, value);
        }

        private static KKey validateKey(KKey key) {
            if (!key.isGroupLevel()) {
                throw new IllegalArgumentException("K-Key of group type expected, but found: " + key);
            }
            return key;
        }
    }

    public static class ValueEntry
    extends AbstractEntry<ValueIndex> {
        public ValueEntry(KKey key, ValueIndex index, Object value) {
            super(ValueEntry.validateKey(key), index, value);
        }

        private static KKey validateKey(KKey key) {
            if (!key.isValueLevel() && !key.isCustomValueLevel()) {
                throw new IllegalArgumentException("K-Key of value type expected, but found: " + key);
            }
            return key;
        }
    }

    public static class CharacteristicEntry
    extends AbstractEntry<CharacteristicIndex> {
        public CharacteristicEntry(KKey key, CharacteristicIndex index, Object value) {
            super(CharacteristicEntry.validateKey(key), index, value);
        }

        private static KKey validateKey(KKey key) {
            if (!key.isCharacteristicLevel() && !key.isCustomCharacteristicLevel()) {
                throw new IllegalArgumentException("K-Key of characteristic type expected, but found: " + key);
            }
            return key;
        }
    }

    public static class PartEntry
    extends AbstractEntry<PartIndex> {
        public PartEntry(KKey key, PartIndex index, Object value) {
            super(PartEntry.validateKey(key), index, value);
        }

        private static KKey validateKey(KKey key) {
            if (!key.isPartLevel() && !key.isCustomPartLevel()) {
                throw new IllegalArgumentException("K-Key of part type expected, but found: " + key);
            }
            return key;
        }
    }

    public static abstract class AbstractEntry<I> {
        private final KKey key;
        private final I index;
        private final Object value;

        public AbstractEntry(KKey key, I index, Object value) {
            this.key = key;
            this.index = index;
            this.value = value;
        }

        public KKey getKey() {
            return this.key;
        }

        public I getIndex() {
            return this.index;
        }

        public Object getValue() {
            return this.value;
        }

        public boolean hasKey(KKey otherkey) {
            return this.key.equals(otherkey);
        }

        public String toString() {
            if (this.value == null) {
                return "null";
            }
            return this.value.toString();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.index == null ? 0 : this.index.hashCode());
            result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof AbstractEntry)) {
                return false;
            }
            AbstractEntry other = (AbstractEntry)obj;
            if (this.index == null ? other.index != null : !this.index.equals(other.index)) {
                return false;
            }
            if (this.key == null ? other.key != null : !this.key.equals(other.key)) {
                return false;
            }
            return !(this.value == null ? other.value != null : !this.value.equals(other.value));
        }
    }

    public static abstract class Entries<E extends AbstractEntry<I>, I>
    extends HashMap<KKey, E>
    implements IHasKKeyValues {
        private final I index;

        public Entries(I index) {
            this.index = index;
        }

        @Override
        public void put(String key, Object value) {
            this.put(KKey.of(key), value);
        }

        @Override
        public void put(KKey key, Object value) {
            this.put(this.newEntry(key, this.index, value));
        }

        public void put(E entry) {
            KKey key = ((AbstractEntry)entry).getKey();
            this.put(key, entry);
        }

        @Override
        public E put(KKey key, E entry) {
            if (!Objects.equals(this.index, ((AbstractEntry)entry).getIndex())) {
                throw new IllegalArgumentException("Index of the entry (" + ((AbstractEntry)entry).getIndex() + ") does not match entries index (" + this.index + ")");
            }
            return (E)((AbstractEntry)super.put(key, entry));
        }

        public void putAll(Collection<? extends E> entries, boolean overwriteExisting) {
            for (AbstractEntry entry : entries) {
                if (overwriteExisting) {
                    this.put(entry.getKey(), (E)entry);
                    continue;
                }
                this.putIfAbsent(entry.getKey(), entry);
            }
        }

        public void putAll(Map<? extends KKey, ? extends E> entries, boolean overwriteExisting) {
            this.putAll(entries.values(), overwriteExisting);
        }

        public E get(KKey key) {
            return (E)((AbstractEntry)super.get(key));
        }

        public <T> T getValue(String key) {
            return this.getValue(KKey.of(key));
        }

        public <T> T getValue(String key, T defaultValue) {
            return this.getValue(KKey.of(key), defaultValue);
        }

        public <T> T getValue(KKey key, T defaultValue) {
            T value = this.getValue(key);
            return value == null ? defaultValue : value;
        }

        @Override
        public <T> T getValue(KKey key) {
            E entry = this.get(key);
            if (entry == null) {
                return null;
            }
            return (T)((AbstractEntry)entry).getValue();
        }

        public E remove(String key) {
            return this.remove(KKey.of(key));
        }

        public E remove(KKey key) {
            return (E)((AbstractEntry)super.remove(key));
        }

        public I getIndex() {
            return this.index;
        }

        public void forEachEntry(Consumer<E> action) {
            this.values().forEach(action);
        }

        protected abstract E newEntry(KKey var1, I var2, Object var3);

        public abstract Entries<E, I> withIndex(I var1);

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.index == null ? 0 : this.index.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (!(obj instanceof Entries)) {
                return false;
            }
            Entries other = (Entries)obj;
            return !(this.index == null ? other.index != null : !this.index.equals(other.index));
        }
    }

    public static class ValueEntries
    extends Entries<ValueEntry, ValueIndex> {
        public ValueEntries(ValueIndex index) {
            super(index);
        }

        public ValueEntries withIndex(ValueIndex index) {
            ValueEntries copy = new ValueEntries(index);
            List entriesCopy = this.values().stream().map(e -> new ValueEntry(e.getKey(), index, e.getValue())).collect(Collectors.toList());
            copy.putAll(entriesCopy, true);
            return copy;
        }

        @Override
        protected ValueEntry newEntry(KKey key, ValueIndex index, Object value) {
            return new ValueEntry(key, index, value);
        }
    }

    public static class GroupEntries
    extends Entries<GroupEntry, GroupIndex> {
        public GroupEntries(GroupIndex index) {
            super(index);
        }

        public GroupEntries withIndex(GroupIndex index) {
            GroupEntries copy = new GroupEntries(index);
            List entriesCopy = this.values().stream().map(e -> new GroupEntry(e.getKey(), index, e.getValue())).collect(Collectors.toList());
            copy.putAll(entriesCopy, true);
            return copy;
        }

        @Override
        protected GroupEntry newEntry(KKey key, GroupIndex index, Object value) {
            return new GroupEntry(key, index, value);
        }
    }

    public static class CharacteristicEntries
    extends Entries<CharacteristicEntry, CharacteristicIndex> {
        public CharacteristicEntries(CharacteristicIndex index) {
            super(index);
        }

        public CharacteristicEntries withIndex(CharacteristicIndex index) {
            CharacteristicEntries copy = new CharacteristicEntries(index);
            List entriesCopy = this.values().stream().map(e -> new CharacteristicEntry(e.getKey(), index, e.getValue())).collect(Collectors.toList());
            copy.putAll(entriesCopy, true);
            return copy;
        }

        @Override
        protected CharacteristicEntry newEntry(KKey key, CharacteristicIndex index, Object value) {
            return new CharacteristicEntry(key, index, value);
        }
    }

    public static class PartEntries
    extends Entries<PartEntry, PartIndex> {
        public PartEntries(PartIndex index) {
            super(index);
        }

        public PartEntries withIndex(PartIndex index) {
            PartEntries copy = new PartEntries(index);
            List entriesCopy = this.values().stream().map(e -> new PartEntry(e.getKey(), index, e.getValue())).collect(Collectors.toList());
            copy.putAll(entriesCopy, true);
            return copy;
        }

        @Override
        protected PartEntry newEntry(KKey key, PartIndex index, Object value) {
            return new PartEntry(key, index, value);
        }
    }

    @FunctionalInterface
    public static interface ValueOfSingleCharacteristicPredicate {
        public boolean test(ValueEntries var1);
    }

    @FunctionalInterface
    public static interface ValueOfSinglePartPredicate {
        public boolean test(CharacteristicEntries var1, ValueEntries var2);
    }

    @FunctionalInterface
    public static interface ValuePredicate {
        public boolean test(PartEntries var1, CharacteristicEntries var2, ValueEntries var3);
    }

    @FunctionalInterface
    public static interface GroupOfSinglePartPredicate {
        public boolean test(GroupEntries var1);
    }

    @FunctionalInterface
    public static interface GroupPredicate {
        public boolean test(PartEntries var1, GroupEntries var2);
    }

    @FunctionalInterface
    public static interface CharacteristicOfSinglePartPredicate {
        public boolean test(CharacteristicEntries var1);
    }

    @FunctionalInterface
    public static interface CharacteristicPredicate {
        public boolean test(PartEntries var1, CharacteristicEntries var2);
    }

    @FunctionalInterface
    public static interface PartPredicate {
        public boolean test(PartEntries var1);
    }

    @FunctionalInterface
    public static interface ValueOfSingleCharacteristicConsumer {
        public void accept(ValueEntries var1);
    }

    @FunctionalInterface
    public static interface ValueOfSinglePartConsumer {
        public void accept(CharacteristicEntries var1, ValueEntries var2);
    }

    @FunctionalInterface
    public static interface ValueConsumer {
        public void accept(PartEntries var1, CharacteristicEntries var2, ValueEntries var3);
    }

    @FunctionalInterface
    public static interface GroupOfSinglePartConsumer {
        public void accept(GroupEntries var1);
    }

    @FunctionalInterface
    public static interface GroupConsumer {
        public void accept(PartEntries var1, GroupEntries var2);
    }

    @FunctionalInterface
    public static interface CharacteristicOfSinglePartConsumer {
        public void accept(CharacteristicEntries var1);
    }

    @FunctionalInterface
    public static interface CharacteristicConsumer {
        public void accept(PartEntries var1, CharacteristicEntries var2);
    }

    @FunctionalInterface
    public static interface PartConsumer {
        public void accept(PartEntries var1);
    }
}

