/*
 * Decompiled with CFR 0.152.
 */
package cz.diribet.aqdef.convert;

import cz.diribet.aqdef.convert.IKKeyValueConverter;
import cz.diribet.aqdef.convert.KKeyValueConversionException;
import java.util.Date;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.FastDateFormat;

public class DateKKeyValueConverter
implements IKKeyValueConverter<Date> {
    private final FastDateFormat outputFormat = this.newDateFormat("dd.MM.yyyy/HH:mm:ss");
    private final FastDateFormat[] inputFormats = new FastDateFormat[]{this.newDateFormat("dd.MM.yy/HH:mm:ss"), this.newDateFormat("MM/dd/yy/HH:mm:ss"), this.newDateFormat("yy-MM-dd/HH:mm:ss"), this.newDateFormat("dd.MM.yy/HH:mm"), this.newDateFormat("MM/dd/yy/HH:mm"), this.newDateFormat("yy-MM-dd/HH:mm"), this.newDateFormat("dd.MM.yy HH:mm:ss"), this.newDateFormat("MM/dd/yy HH:mm:ss"), this.newDateFormat("yy-MM-dd HH:mm:ss"), this.newDateFormat("dd.MM.yy HH:mm"), this.newDateFormat("MM/dd/yy HH:mm"), this.newDateFormat("yy-MM-dd HH:mm")};

    private FastDateFormat newDateFormat(String pattern) {
        return FastDateFormat.getInstance((String)pattern, (TimeZone)TimeZone.getDefault());
    }

    @Override
    public Date convert(String value) throws KKeyValueConversionException {
        if (StringUtils.isEmpty((CharSequence)value)) {
            return null;
        }
        Throwable firstException = null;
        for (FastDateFormat inputFormat : this.inputFormats) {
            try {
                return inputFormat.parse(value);
            }
            catch (Throwable e) {
                if (firstException != null) continue;
                firstException = e;
            }
        }
        throw new KKeyValueConversionException(value, Date.class, firstException);
    }

    @Override
    public String toString(Date value) {
        if (value == null) {
            return null;
        }
        return this.outputFormat.format(value);
    }
}

