/*
 * Decompiled with CFR 0.152.
 */
package cz.diribet.aqdef.model;

import cz.diribet.aqdef.KKey;
import cz.diribet.aqdef.model.AqdefObjectModel;
import cz.diribet.aqdef.model.CharacteristicIndex;
import cz.diribet.aqdef.model.GroupIndex;
import cz.diribet.aqdef.model.NodeIndex;
import cz.diribet.aqdef.model.PartIndex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.commons.collections4.CollectionUtils;

public class AqdefHierarchy {
    private static final KKey KEY_PART_NODE = KKey.of("K5111");
    private static final KKey KEY_CHARACTERISTIC_NODE = KKey.of("K5112");
    private static final KKey KEY_GROUP_NODE = KKey.of("K5113");
    private static final KKey KEY_NODE_BINDING = KKey.of("K5103");
    private static final KKey KEY_CHARACTERISTIC_BINDING = KKey.of("K5102");
    private static final KKey KEY_SIMPLE_GROUPING_CHARACTERISTIC_PARENT = KKey.of("K2030");
    private static final KKey KEY_SIMPLE_GROUPING_CHARACTERISTIC_CHILD = KKey.of("K2031");
    private TreeMap<NodeIndex, HierarchyEntry> nodeDefinitions = new TreeMap();
    private TreeMap<NodeIndex, List<HierarchyEntry>> nodeBindings = new TreeMap();
    private boolean containsHierarchyInformation = false;
    private boolean containsSimpleHierarchyInformation = false;

    public void putEntry(KKey kKey, Integer index, Object value) {
        Objects.requireNonNull(kKey);
        if (kKey.isSimpleHierarchyLevel()) {
            this.putSimpleHierarchyEntry(kKey, index, value);
        } else if (AqdefHierarchy.isNodeDefinition(kKey) || this.isBinding(kKey)) {
            NodeIndex nodeIndex = NodeIndex.of(index);
            this.putEntry(new HierarchyEntry(kKey, nodeIndex, (Integer)value));
        } else {
            throw new IllegalArgumentException("Unknown hierarchy entry. Key: " + kKey + " Value: " + value);
        }
    }

    public void putEntry(HierarchyEntry entry) {
        Objects.requireNonNull(entry);
        KKey kKey = entry.getKey();
        if (kKey.isSimpleHierarchyLevel()) {
            throw new RuntimeException("Direct insertion of simple hierarchy entry is not supported");
        }
        if (this.containsSimpleHierarchyInformation) {
            throw new RuntimeException("Combination of hierarchy (K51xx) and simple hierarchy (K2030/2031) is not supported");
        }
        this.putEntryInternal(entry);
        this.containsHierarchyInformation = true;
    }

    private void putSimpleHierarchyEntry(KKey kKey, Integer index, Object value) {
        if (value == null) {
            return;
        }
        int valueInt = (Integer)value;
        if (valueInt == 0) {
            return;
        }
        if (this.containsHierarchyInformation) {
            throw new RuntimeException("Combination of hierarchy (K51xx) and simple hierarchy (K2030/2031) is not supported");
        }
        NodeIndex nodeIndex = NodeIndex.of(valueInt);
        if (AqdefHierarchy.isCharacteristicSimpleGroupingParent(kKey)) {
            HierarchyEntry hierarchyEntry = new HierarchyEntry(KEY_CHARACTERISTIC_NODE, nodeIndex, index);
            this.putEntryInternal(hierarchyEntry);
        } else if (AqdefHierarchy.isCharacteristicSimpleGroupingChild(kKey)) {
            HierarchyEntry hierarchyEntry;
            Optional<NodeIndex> existingNodeIndexOfCharacteristic = this.getNodeIndexOfCharacteristic(index);
            if (existingNodeIndexOfCharacteristic.isPresent()) {
                Integer existingNodeIndexOfCharacteristicInt = existingNodeIndexOfCharacteristic.get().getIndex();
                hierarchyEntry = new HierarchyEntry(KEY_NODE_BINDING, nodeIndex, existingNodeIndexOfCharacteristicInt);
            } else {
                hierarchyEntry = new HierarchyEntry(KEY_CHARACTERISTIC_BINDING, nodeIndex, index);
            }
            this.putEntryInternal(hierarchyEntry);
        } else {
            throw new IllegalArgumentException("Unknown simple hierarchy entry. Key: " + kKey + " Value: " + value);
        }
        this.containsSimpleHierarchyInformation = true;
    }

    private void putEntryInternal(HierarchyEntry entry) {
        KKey kKey = entry.getKey();
        if (AqdefHierarchy.isNodeDefinition(kKey)) {
            this.nodeDefinitions.put((NodeIndex)entry.getIndex(), entry);
        } else if (this.isBinding(kKey)) {
            this.nodeBindings.computeIfAbsent((NodeIndex)entry.getIndex(), k -> new ArrayList()).add(entry);
        } else {
            throw new IllegalArgumentException("Unknown hierarchy entry. Key: " + kKey + " Value: " + entry.getValue());
        }
    }

    public void removeHierarchyForPart(PartIndex index) {
        if (index == null) {
            return;
        }
        Optional<NodeIndex> nodeIndex = this.getNodeIndexOfPart(index.getIndex());
        nodeIndex.ifPresent(this::removeHierarchyPartForNode);
    }

    public void removeHierarchyForCharacteristic(CharacteristicIndex index) {
        this.removeHierarchyForCharacteristic(index, true);
    }

    private void removeHierarchyForCharacteristic(CharacteristicIndex index, boolean removeParentBinding) {
        if (index == null) {
            return;
        }
        Integer characteristicIndex = index.getCharacteristicIndex();
        Optional<NodeIndex> nodeIndexOfCharacteristic = this.getNodeIndexOfCharacteristic(characteristicIndex);
        nodeIndexOfCharacteristic.ifPresent(this::removeHierarchyPartForNode);
        if (removeParentBinding) {
            this.removeParentBinding(characteristicIndex, nodeIndexOfCharacteristic.orElse(null));
        }
    }

    public void removeHierarchyForGroup(GroupIndex index) {
        this.removeHierarchyForGroup(index, true);
    }

    private void removeHierarchyForGroup(GroupIndex index, boolean removeParentBinding) {
        if (index == null) {
            return;
        }
        Integer groupIndex = index.getGroupIndex();
        Optional<NodeIndex> nodeIndexOfGroup = this.getNodeIndexOfGroup(groupIndex);
        nodeIndexOfGroup.ifPresent(this::removeHierarchyPartForNode);
        if (removeParentBinding && nodeIndexOfGroup.isPresent()) {
            this.removeParentBinding(groupIndex, nodeIndexOfGroup.get());
        }
    }

    private void removeHierarchyPartForNode(NodeIndex nodeIndex) {
        if (nodeIndex == null || !this.nodeDefinitions.containsKey(nodeIndex)) {
            return;
        }
        List childBindings = this.nodeBindings.getOrDefault(nodeIndex, Collections.emptyList());
        for (HierarchyEntry entry : childBindings) {
            NodeIndex childNodeIndex = NodeIndex.of((int)((Integer)entry.getValue()));
            if (!AqdefHierarchy.isNodeBinding(entry.getKey())) continue;
            this.getCharacteristicOrGroupIndexOfNode(childNodeIndex, PartIndex.of(1)).ifPresent(elementIndex -> {
                if (elementIndex instanceof CharacteristicIndex) {
                    this.removeHierarchyForCharacteristic((CharacteristicIndex)elementIndex, false);
                } else if (elementIndex instanceof GroupIndex) {
                    this.removeHierarchyForGroup((GroupIndex)elementIndex, false);
                }
            });
        }
        this.nodeBindings.remove(nodeIndex);
        this.nodeDefinitions.remove(nodeIndex);
    }

    private void removeParentBinding(Integer index, NodeIndex nodeIndex) {
        if (index == null) {
            return;
        }
        for (List<HierarchyEntry> bindings : this.nodeBindings.values()) {
            Predicate<HierarchyEntry> filter;
            if (bindings.removeIf(filter = entry -> {
                KKey kKey = entry.getKey();
                if (nodeIndex != null) {
                    return nodeIndex.getIndex().equals(entry.getValue()) && AqdefHierarchy.isNodeBinding(kKey);
                }
                return index.equals(entry.getValue()) && AqdefHierarchy.isCharacteristicBinding(kKey);
            })) break;
        }
    }

    public AqdefHierarchy normalize(AqdefObjectModel aqdefObjectModel) {
        Objects.requireNonNull(aqdefObjectModel);
        if (this != aqdefObjectModel.getHierarchy()) {
            throw new IllegalArgumentException("The provided aqdef model does not contain this normalized hierarchy");
        }
        return this.normalizeSimpleCharacteristicsGrouping(aqdefObjectModel);
    }

    private AqdefHierarchy normalizeSimpleCharacteristicsGrouping(AqdefObjectModel aqdefObjectModel) {
        if (!this.containsSimpleHierarchyInformation) {
            return this;
        }
        this.forEachNodeDefinition(entry -> {
            KKey kKey = entry.getKey();
            if (AqdefHierarchy.isPartNode(kKey)) {
                throw new IllegalStateException("Hierarchy was created from a simple characteristics grouping. It should not contain any part node element, but it does.");
            }
            if (AqdefHierarchy.isGroupNode(kKey)) {
                throw new IllegalStateException("Hierarchy was created from a simple characteristics grouping. It should not contain any logical group node element, but it does.");
            }
        });
        AqdefHierarchy normalizedHierarchy = new AqdefHierarchy();
        AtomicInteger hierarchyNodeIndexCounter = new AtomicInteger();
        aqdefObjectModel.forEachPart(part -> {
            Integer partIndex = ((PartIndex)part.getIndex()).getIndex();
            NodeIndex partNodeIndex = NodeIndex.of(hierarchyNodeIndexCounter.incrementAndGet());
            normalizedHierarchy.putEntry(new HierarchyEntry(KEY_PART_NODE, partNodeIndex, partIndex));
            HashMap nodesIndexMap = new HashMap();
            this.forEachNodeDefinition(entry -> {
                KKey kKey = entry.getKey();
                Integer characteristicIndex = (Integer)entry.getValue();
                NodeIndex characteristicsNodeIndex = NodeIndex.of(hierarchyNodeIndexCounter.incrementAndGet());
                normalizedHierarchy.putEntry(new HierarchyEntry(kKey, characteristicsNodeIndex, characteristicIndex));
                nodesIndexMap.put(((NodeIndex)entry.getIndex()).getIndex(), characteristicsNodeIndex.getIndex());
            });
            this.forEachNodeDefinition(entry -> {
                NodeIndex oldNodeIndex = (NodeIndex)entry.getIndex();
                Integer nodeIndex = (Integer)nodesIndexMap.get(oldNodeIndex.getIndex());
                if (!this.getParentNodeIndexOfNode(oldNodeIndex).isPresent()) {
                    normalizedHierarchy.putEntry(new HierarchyEntry(KEY_NODE_BINDING, partNodeIndex, nodeIndex));
                }
            });
            this.forEachNodeBinding(entry -> {
                KKey kKey = entry.getKey();
                NodeIndex characteristicBindingSourceNodeIndex = (NodeIndex)entry.getIndex();
                characteristicBindingSourceNodeIndex = NodeIndex.of((Integer)nodesIndexMap.get(characteristicBindingSourceNodeIndex.getIndex()));
                Integer characteristicBindingTargetNodeIndex = (Integer)entry.getValue();
                if (AqdefHierarchy.isNodeBinding(kKey)) {
                    characteristicBindingTargetNodeIndex = (Integer)nodesIndexMap.get(characteristicBindingTargetNodeIndex);
                }
                normalizedHierarchy.putEntry(new HierarchyEntry(kKey, characteristicBindingSourceNodeIndex, characteristicBindingTargetNodeIndex));
            });
            aqdefObjectModel.forEachCharacteristic(part, characteristic -> {
                CharacteristicIndex characteristicIndex = (CharacteristicIndex)characteristic.getIndex();
                Integer characteristicIndexInt = characteristicIndex.getCharacteristicIndex();
                if (this.getNodeIndexOfCharacteristic(characteristicIndexInt).isPresent() || this.getParentNodeIndexOfCharacteristic(characteristicIndexInt).isPresent()) {
                    return;
                }
                normalizedHierarchy.putEntry(new HierarchyEntry(KEY_CHARACTERISTIC_BINDING, partNodeIndex, characteristicIndex.getCharacteristicIndex()));
            });
        });
        return normalizedHierarchy;
    }

    public void forEachNodeDefinition(Consumer<HierarchyEntry> action) {
        this.nodeDefinitions.values().forEach(action);
    }

    public void forEachNodeBinding(Consumer<HierarchyEntry> action) {
        this.nodeBindings.values().stream().flatMap(Collection::stream).forEach(action);
    }

    public boolean isEmpty() {
        return this.nodeDefinitions.isEmpty() && this.nodeBindings.isEmpty();
    }

    public boolean hasChildren(CharacteristicIndex characteristicIndex) {
        Integer characteristicIndexInt = characteristicIndex == null ? null : characteristicIndex.getCharacteristicIndex();
        Optional<NodeIndex> nodeIndexOfCharacteristic = this.getNodeIndexOfCharacteristic(characteristicIndexInt);
        if (nodeIndexOfCharacteristic.isPresent()) {
            List<HierarchyEntry> children = this.nodeBindings.get(nodeIndexOfCharacteristic.get());
            return CollectionUtils.isNotEmpty(children);
        }
        return false;
    }

    public Optional<Object> getParentIndex(CharacteristicIndex characteristicIndex) {
        Optional<NodeIndex> parentNodeIndex;
        Integer characteristicIndexInt = characteristicIndex == null ? null : characteristicIndex.getCharacteristicIndex();
        Optional<NodeIndex> parentNodeIndexOfCharacteristic = this.getParentNodeIndexOfCharacteristic(characteristicIndexInt);
        if (parentNodeIndexOfCharacteristic.isPresent()) {
            return this.getCharacteristicOrGroupIndexOfNode(parentNodeIndexOfCharacteristic.get(), characteristicIndex.getPartIndex());
        }
        Optional<NodeIndex> nodeIndexOfCharacteristic = this.getNodeIndexOfCharacteristic(characteristicIndexInt);
        if (nodeIndexOfCharacteristic.isPresent() && (parentNodeIndex = this.getParentNodeIndexOfNode(nodeIndexOfCharacteristic.get())).isPresent()) {
            return this.getCharacteristicOrGroupIndexOfNode(parentNodeIndex.get(), characteristicIndex.getPartIndex());
        }
        return Optional.empty();
    }

    public Optional<Object> getParentIndex(GroupIndex groupIndex) {
        Optional<NodeIndex> parentNodeIndex;
        Integer groupIndexInt = groupIndex == null ? null : groupIndex.getGroupIndex();
        Optional<NodeIndex> nodeIndexOfGroup = this.getNodeIndexOfGroup(groupIndexInt);
        if (nodeIndexOfGroup.isPresent() && (parentNodeIndex = this.getParentNodeIndexOfNode(nodeIndexOfGroup.get())).isPresent()) {
            return this.getCharacteristicOrGroupIndexOfNode(parentNodeIndex.get(), groupIndex.getPartIndex());
        }
        return Optional.empty();
    }

    private Optional<Object> getCharacteristicOrGroupIndexOfNode(NodeIndex nodeIndex, PartIndex partIndex) {
        HierarchyEntry nodeDefinition = this.nodeDefinitions.get(nodeIndex);
        Integer index = (Integer)nodeDefinition.getValue();
        if (nodeDefinition.getKey().equals(KEY_CHARACTERISTIC_NODE)) {
            return Optional.of(CharacteristicIndex.of(partIndex, index));
        }
        if (nodeDefinition.getKey().equals(KEY_GROUP_NODE)) {
            return Optional.of(GroupIndex.of(partIndex, index));
        }
        return Optional.empty();
    }

    private Optional<NodeIndex> getParentNodeIndexOfNode(NodeIndex nodeIndex) {
        return this.nodeBindings.values().stream().flatMap(Collection::stream).filter(hierarchyEntry -> hierarchyEntry.getKey().equals(KEY_NODE_BINDING) && nodeIndex.getIndex().equals(hierarchyEntry.getValue())).map(AqdefObjectModel.AbstractEntry::getIndex).findAny();
    }

    private Optional<NodeIndex> getParentNodeIndexOfCharacteristic(Integer characteristicIndex) {
        if (characteristicIndex == null) {
            return Optional.empty();
        }
        return this.nodeBindings.values().stream().flatMap(Collection::stream).filter(hierarchyEntry -> hierarchyEntry.getKey().equals(KEY_CHARACTERISTIC_BINDING) && characteristicIndex.equals(hierarchyEntry.getValue())).map(AqdefObjectModel.AbstractEntry::getIndex).findAny();
    }

    private Optional<NodeIndex> getNodeIndexOfPart(Integer partIndex) {
        if (partIndex == null) {
            return Optional.empty();
        }
        return this.nodeDefinitions.entrySet().stream().filter(entry -> {
            HierarchyEntry hierarchyEntry = (HierarchyEntry)entry.getValue();
            return KEY_PART_NODE.equals(hierarchyEntry.getKey()) && partIndex.equals(hierarchyEntry.getValue());
        }).map(Map.Entry::getKey).findAny();
    }

    private Optional<NodeIndex> getNodeIndexOfCharacteristic(Integer characteristicIndex) {
        if (characteristicIndex == null) {
            return Optional.empty();
        }
        return this.nodeDefinitions.entrySet().stream().filter(entry -> {
            HierarchyEntry hierarchyEntry = (HierarchyEntry)entry.getValue();
            return KEY_CHARACTERISTIC_NODE.equals(hierarchyEntry.getKey()) && characteristicIndex.equals(hierarchyEntry.getValue());
        }).map(Map.Entry::getKey).findAny();
    }

    private Optional<NodeIndex> getNodeIndexOfGroup(Integer groupIndex) {
        if (groupIndex == null) {
            return Optional.empty();
        }
        return this.nodeDefinitions.entrySet().stream().filter(entry -> {
            HierarchyEntry hierarchyEntry = (HierarchyEntry)entry.getValue();
            return KEY_GROUP_NODE.equals(hierarchyEntry.getKey()) && groupIndex.equals(hierarchyEntry.getValue());
        }).map(Map.Entry::getKey).findAny();
    }

    private boolean isBinding(KKey kKey) {
        return AqdefHierarchy.isNodeBinding(kKey) || AqdefHierarchy.isCharacteristicBinding(kKey);
    }

    private static boolean isNodeBinding(KKey kKey) {
        return kKey.equals(KEY_NODE_BINDING);
    }

    private static boolean isCharacteristicBinding(KKey kKey) {
        return kKey.equals(KEY_CHARACTERISTIC_BINDING);
    }

    private static boolean isNodeDefinition(KKey kKey) {
        return AqdefHierarchy.isPartNode(kKey) || AqdefHierarchy.isCharacteristicNode(kKey) || AqdefHierarchy.isGroupNode(kKey);
    }

    private static boolean isPartNode(KKey kKey) {
        return kKey.equals(KEY_PART_NODE);
    }

    private static boolean isCharacteristicNode(KKey kKey) {
        return kKey.equals(KEY_CHARACTERISTIC_NODE);
    }

    private static boolean isGroupNode(KKey kKey) {
        return kKey.equals(KEY_GROUP_NODE);
    }

    private static boolean isCharacteristicSimpleGroupingParent(KKey kKey) {
        return kKey.equals(KEY_SIMPLE_GROUPING_CHARACTERISTIC_PARENT);
    }

    private static boolean isCharacteristicSimpleGroupingChild(KKey kKey) {
        return kKey.equals(KEY_SIMPLE_GROUPING_CHARACTERISTIC_CHILD);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AqdefHierarchy)) {
            return false;
        }
        AqdefHierarchy other = (AqdefHierarchy)o;
        if (!other.canEqual(this)) {
            return false;
        }
        TreeMap<NodeIndex, HierarchyEntry> this$nodeDefinitions = this.nodeDefinitions;
        TreeMap<NodeIndex, HierarchyEntry> other$nodeDefinitions = other.nodeDefinitions;
        if (this$nodeDefinitions == null ? other$nodeDefinitions != null : !((Object)this$nodeDefinitions).equals(other$nodeDefinitions)) {
            return false;
        }
        TreeMap<NodeIndex, List<HierarchyEntry>> this$nodeBindings = this.nodeBindings;
        TreeMap<NodeIndex, List<HierarchyEntry>> other$nodeBindings = other.nodeBindings;
        return !(this$nodeBindings == null ? other$nodeBindings != null : !((Object)this$nodeBindings).equals(other$nodeBindings));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AqdefHierarchy;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TreeMap<NodeIndex, HierarchyEntry> $nodeDefinitions = this.nodeDefinitions;
        result = result * 59 + ($nodeDefinitions == null ? 43 : ((Object)$nodeDefinitions).hashCode());
        TreeMap<NodeIndex, List<HierarchyEntry>> $nodeBindings = this.nodeBindings;
        result = result * 59 + ($nodeBindings == null ? 43 : ((Object)$nodeBindings).hashCode());
        return result;
    }

    public static class HierarchyEntry
    extends AqdefObjectModel.AbstractEntry<NodeIndex> {
        public HierarchyEntry(KKey key, NodeIndex index, Integer value) {
            super(HierarchyEntry.validateKey(key), index, value);
        }

        private static KKey validateKey(KKey key) {
            if (!key.isHierarchyLevel()) {
                throw new IllegalArgumentException("K-Key of hierarchy type expected, but found: " + key);
            }
            return key;
        }
    }
}

