/*
 * Decompiled with CFR 0.152.
 */
package cz.diribet.aqdef.convert;

import cz.diribet.aqdef.convert.IKKeyValueConverter;
import cz.diribet.aqdef.convert.KKeyValueConversionException;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class DateKKeyValueConverter
implements IKKeyValueConverter<Date> {
    private static final DateTimeFormatter OUTPUT_FORMATTER = DateKKeyValueConverter.newDateFormat("dd.MM.yyyy/HH:mm:ss");
    private static final List<DateTimeFormatter> INPUT_FORMATTERS = List.of(DateKKeyValueConverter.newDateFormat("d.M.yy/H:m:s"), DateKKeyValueConverter.newDateFormat("d.M.yy/H:m"), DateKKeyValueConverter.newDateFormat("d.M.yyyy/H:m:s"), DateKKeyValueConverter.newDateFormat("d.M.yyyy/H:m"), DateKKeyValueConverter.newDateFormat("M/d/yy/H:m:s"), DateKKeyValueConverter.newDateFormat("M/d/yy/H:m"), DateKKeyValueConverter.newDateFormat("M/d/yyyy/H:m:s"), DateKKeyValueConverter.newDateFormat("M/d/yyyy/H:m"), DateKKeyValueConverter.newDateFormat("yy-M-d/H:m:s"), DateKKeyValueConverter.newDateFormat("yy-M-d/H:m"), DateKKeyValueConverter.newDateFormat("yyyy-M-d/H:m:s"), DateKKeyValueConverter.newDateFormat("yyyy-M-d/H:m"), DateKKeyValueConverter.newDateFormat("d.M.yy H:m:s"), DateKKeyValueConverter.newDateFormat("d.M.yy H:m"), DateKKeyValueConverter.newDateFormat("d.M.yyyy H:m:s"), DateKKeyValueConverter.newDateFormat("d.M.yyyy H:m"), DateKKeyValueConverter.newDateFormat("M/d/yy H:m:s"), DateKKeyValueConverter.newDateFormat("M/d/yy H:m"), DateKKeyValueConverter.newDateFormat("M/d/yyyy H:m:s"), DateKKeyValueConverter.newDateFormat("M/d/yyyy H:m"), DateKKeyValueConverter.newDateFormat("yy-M-d H:m:s"), DateKKeyValueConverter.newDateFormat("yy-M-d H:m"), DateKKeyValueConverter.newDateFormat("yyyy-M-d H:m:s"), DateKKeyValueConverter.newDateFormat("yyyy-M-d H:m"));

    private static DateTimeFormatter newDateFormat(String pattern) {
        return DateTimeFormatter.ofPattern(pattern);
    }

    @Override
    public Date convert(String value) throws KKeyValueConversionException {
        if (StringUtils.isEmpty((CharSequence)value)) {
            return null;
        }
        for (DateTimeFormatter inputFormat : INPUT_FORMATTERS) {
            try {
                LocalDateTime dateTime = LocalDateTime.parse(value, inputFormat);
                return Date.from(dateTime.atZone(ZoneId.systemDefault()).toInstant());
            }
            catch (Throwable throwable) {
            }
        }
        throw new KKeyValueConversionException("Failed to convert value:" + value + " to Date. Unsupported format.");
    }

    @Override
    public String toString(Date value) {
        if (value == null) {
            return null;
        }
        return OUTPUT_FORMATTER.format(value.toInstant());
    }
}

